/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.devtools.domsnapshot.model;

import com.google.common.reflect.TypeToken;
import java.util.List;
import java.util.Objects;
import org.openqa.selenium.devtools.dom.model.BackendNodeId;
import org.openqa.selenium.devtools.dom.model.PseudoType;
import org.openqa.selenium.devtools.dom.model.ShadowRootType;
import org.openqa.selenium.devtools.domdebugger.model.EventListener;
import org.openqa.selenium.devtools.domsnapshot.model.NameValue;
import org.openqa.selenium.devtools.page.model.FrameId;
import org.openqa.selenium.json.JsonInput;

public class DOMNode {
    private final Integer nodeType;
    private final String nodeName;
    private final String nodeValue;
    private final String textValue;
    private final String inputValue;
    private final Boolean inputChecked;
    private final Boolean optionSelected;
    private final BackendNodeId backendNodeId;
    private final List<Integer> childNodeIndexes;
    private final List<NameValue> attributes;
    private final List<Integer> pseudoElementIndexes;
    private final Integer layoutNodeIndex;
    private final String documentURL;
    private final String baseURL;
    private final String contentLanguage;
    private final String documentEncoding;
    private final String publicId;
    private final String systemId;
    private final FrameId frameId;
    private final Integer contentDocumentIndex;
    private final PseudoType pseudoType;
    private final ShadowRootType shadowRootType;
    private final Boolean isClickable;
    private final List<EventListener> eventListeners;
    private final String currentSourceURL;
    private final String originURL;
    private final Number scrollOffsetX;
    private final Number scrollOffsetY;

    public DOMNode(Integer nodeType, String nodeName, String nodeValue, String textValue, String inputValue, Boolean inputChecked, Boolean optionSelected, BackendNodeId backendNodeId, List<Integer> childNodeIndexes, List<NameValue> attributes, List<Integer> pseudoElementIndexes, Integer layoutNodeIndex, String documentURL, String baseURL, String contentLanguage, String documentEncoding, String publicId, String systemId, FrameId frameId, Integer contentDocumentIndex, PseudoType pseudoType, ShadowRootType shadowRootType, Boolean isClickable, List<EventListener> eventListeners, String currentSourceURL, String originURL, Number scrollOffsetX, Number scrollOffsetY) {
        this.nodeType = Objects.requireNonNull(nodeType, "nodeType is required");
        this.nodeName = Objects.requireNonNull(nodeName, "nodeName is required");
        this.nodeValue = Objects.requireNonNull(nodeValue, "nodeValue is required");
        this.textValue = textValue;
        this.inputValue = inputValue;
        this.inputChecked = inputChecked;
        this.optionSelected = optionSelected;
        this.backendNodeId = Objects.requireNonNull(backendNodeId, "backendNodeId is required");
        this.childNodeIndexes = childNodeIndexes;
        this.attributes = attributes;
        this.pseudoElementIndexes = pseudoElementIndexes;
        this.layoutNodeIndex = layoutNodeIndex;
        this.documentURL = documentURL;
        this.baseURL = baseURL;
        this.contentLanguage = contentLanguage;
        this.documentEncoding = documentEncoding;
        this.publicId = publicId;
        this.systemId = systemId;
        this.frameId = frameId;
        this.contentDocumentIndex = contentDocumentIndex;
        this.pseudoType = pseudoType;
        this.shadowRootType = shadowRootType;
        this.isClickable = isClickable;
        this.eventListeners = eventListeners;
        this.currentSourceURL = currentSourceURL;
        this.originURL = originURL;
        this.scrollOffsetX = scrollOffsetX;
        this.scrollOffsetY = scrollOffsetY;
    }

    public Integer getNodeType() {
        return this.nodeType;
    }

    public String getNodeName() {
        return this.nodeName;
    }

    public String getNodeValue() {
        return this.nodeValue;
    }

    public String getTextValue() {
        return this.textValue;
    }

    public String getInputValue() {
        return this.inputValue;
    }

    public Boolean getInputChecked() {
        return this.inputChecked;
    }

    public Boolean getOptionSelected() {
        return this.optionSelected;
    }

    public BackendNodeId getBackendNodeId() {
        return this.backendNodeId;
    }

    public List<Integer> getChildNodeIndexes() {
        return this.childNodeIndexes;
    }

    public List<NameValue> getAttributes() {
        return this.attributes;
    }

    public List<Integer> getPseudoElementIndexes() {
        return this.pseudoElementIndexes;
    }

    public Integer getLayoutNodeIndex() {
        return this.layoutNodeIndex;
    }

    public String getDocumentURL() {
        return this.documentURL;
    }

    public String getBaseURL() {
        return this.baseURL;
    }

    public String getContentLanguage() {
        return this.contentLanguage;
    }

    public String getDocumentEncoding() {
        return this.documentEncoding;
    }

    public String getPublicId() {
        return this.publicId;
    }

    public String getSystemId() {
        return this.systemId;
    }

    public FrameId getFrameId() {
        return this.frameId;
    }

    public Integer getContentDocumentIndex() {
        return this.contentDocumentIndex;
    }

    public PseudoType getPseudoType() {
        return this.pseudoType;
    }

    public ShadowRootType getShadowRootType() {
        return this.shadowRootType;
    }

    public Boolean getIsClickable() {
        return this.isClickable;
    }

    public List<EventListener> getEventListeners() {
        return this.eventListeners;
    }

    public String getCurrentSourceURL() {
        return this.currentSourceURL;
    }

    public String getOriginURL() {
        return this.originURL;
    }

    public Number getScrollOffsetX() {
        return this.scrollOffsetX;
    }

    public Number getScrollOffsetY() {
        return this.scrollOffsetY;
    }

    private static DOMNode fromJson(JsonInput input) {
        Integer nodeType = null;
        String nodeName = null;
        String nodeValue = null;
        String textValue = null;
        String inputValue = null;
        Boolean inputChecked = null;
        Boolean optionSelected = null;
        BackendNodeId backendNodeId = null;
        List childNodeIndexes = null;
        List attributes = null;
        List pseudoElementIndexes = null;
        Integer layoutNodeIndex = null;
        String documentURL = null;
        String baseURL = null;
        String contentLanguage = null;
        String documentEncoding = null;
        String publicId = null;
        String systemId = null;
        FrameId frameId = null;
        Integer contentDocumentIndex = null;
        PseudoType pseudoType = null;
        ShadowRootType shadowRootType = null;
        Boolean isClickable = null;
        List eventListeners = null;
        String currentSourceURL = null;
        String originURL = null;
        Number scrollOffsetX = null;
        Number scrollOffsetY = null;
        input.beginObject();
        block60: while (input.hasNext()) {
            switch (input.nextName()) {
                case "nodeType": {
                    nodeType = input.nextNumber().intValue();
                    continue block60;
                }
                case "nodeName": {
                    nodeName = input.nextString();
                    continue block60;
                }
                case "nodeValue": {
                    nodeValue = input.nextString();
                    continue block60;
                }
                case "textValue": {
                    textValue = input.nextString();
                    continue block60;
                }
                case "inputValue": {
                    inputValue = input.nextString();
                    continue block60;
                }
                case "inputChecked": {
                    inputChecked = input.nextBoolean();
                    continue block60;
                }
                case "optionSelected": {
                    optionSelected = input.nextBoolean();
                    continue block60;
                }
                case "backendNodeId": {
                    backendNodeId = (BackendNodeId)input.read(BackendNodeId.class);
                    continue block60;
                }
                case "childNodeIndexes": {
                    childNodeIndexes = (List)input.read(new TypeToken<List<Integer>>(){}.getType());
                    continue block60;
                }
                case "attributes": {
                    attributes = (List)input.read(new TypeToken<List<NameValue>>(){}.getType());
                    continue block60;
                }
                case "pseudoElementIndexes": {
                    pseudoElementIndexes = (List)input.read(new TypeToken<List<Integer>>(){}.getType());
                    continue block60;
                }
                case "layoutNodeIndex": {
                    layoutNodeIndex = input.nextNumber().intValue();
                    continue block60;
                }
                case "documentURL": {
                    documentURL = input.nextString();
                    continue block60;
                }
                case "baseURL": {
                    baseURL = input.nextString();
                    continue block60;
                }
                case "contentLanguage": {
                    contentLanguage = input.nextString();
                    continue block60;
                }
                case "documentEncoding": {
                    documentEncoding = input.nextString();
                    continue block60;
                }
                case "publicId": {
                    publicId = input.nextString();
                    continue block60;
                }
                case "systemId": {
                    systemId = input.nextString();
                    continue block60;
                }
                case "frameId": {
                    frameId = (FrameId)input.read(FrameId.class);
                    continue block60;
                }
                case "contentDocumentIndex": {
                    contentDocumentIndex = input.nextNumber().intValue();
                    continue block60;
                }
                case "pseudoType": {
                    pseudoType = (PseudoType)((Object)input.read(PseudoType.class));
                    continue block60;
                }
                case "shadowRootType": {
                    shadowRootType = (ShadowRootType)((Object)input.read(ShadowRootType.class));
                    continue block60;
                }
                case "isClickable": {
                    isClickable = input.nextBoolean();
                    continue block60;
                }
                case "eventListeners": {
                    eventListeners = (List)input.read(new TypeToken<List<EventListener>>(){}.getType());
                    continue block60;
                }
                case "currentSourceURL": {
                    currentSourceURL = input.nextString();
                    continue block60;
                }
                case "originURL": {
                    originURL = input.nextString();
                    continue block60;
                }
                case "scrollOffsetX": {
                    scrollOffsetX = input.nextNumber();
                    continue block60;
                }
                case "scrollOffsetY": {
                    scrollOffsetY = input.nextNumber();
                    continue block60;
                }
            }
            input.skipValue();
        }
        input.endObject();
        return new DOMNode(nodeType, nodeName, nodeValue, textValue, inputValue, inputChecked, optionSelected, backendNodeId, childNodeIndexes, attributes, pseudoElementIndexes, layoutNodeIndex, documentURL, baseURL, contentLanguage, documentEncoding, publicId, systemId, frameId, contentDocumentIndex, pseudoType, shadowRootType, isClickable, eventListeners, currentSourceURL, originURL, scrollOffsetX, scrollOffsetY);
    }
}

