/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.devtools.domdebugger.model;

import java.util.Objects;
import org.openqa.selenium.devtools.dom.model.BackendNodeId;
import org.openqa.selenium.devtools.runtime.model.RemoteObject;
import org.openqa.selenium.devtools.runtime.model.ScriptId;
import org.openqa.selenium.json.JsonInput;

public class EventListener {
    private final String type;
    private final Boolean useCapture;
    private final Boolean passive;
    private final Boolean once;
    private final ScriptId scriptId;
    private final Integer lineNumber;
    private final Integer columnNumber;
    private final RemoteObject handler;
    private final RemoteObject originalHandler;
    private final BackendNodeId backendNodeId;

    public EventListener(String type, Boolean useCapture, Boolean passive, Boolean once, ScriptId scriptId, Integer lineNumber, Integer columnNumber, RemoteObject handler, RemoteObject originalHandler, BackendNodeId backendNodeId) {
        this.type = Objects.requireNonNull(type, "type is required");
        this.useCapture = Objects.requireNonNull(useCapture, "useCapture is required");
        this.passive = Objects.requireNonNull(passive, "passive is required");
        this.once = Objects.requireNonNull(once, "once is required");
        this.scriptId = Objects.requireNonNull(scriptId, "scriptId is required");
        this.lineNumber = Objects.requireNonNull(lineNumber, "lineNumber is required");
        this.columnNumber = Objects.requireNonNull(columnNumber, "columnNumber is required");
        this.handler = handler;
        this.originalHandler = originalHandler;
        this.backendNodeId = backendNodeId;
    }

    public String getType() {
        return this.type;
    }

    public Boolean getUseCapture() {
        return this.useCapture;
    }

    public Boolean getPassive() {
        return this.passive;
    }

    public Boolean getOnce() {
        return this.once;
    }

    public ScriptId getScriptId() {
        return this.scriptId;
    }

    public Integer getLineNumber() {
        return this.lineNumber;
    }

    public Integer getColumnNumber() {
        return this.columnNumber;
    }

    public RemoteObject getHandler() {
        return this.handler;
    }

    public RemoteObject getOriginalHandler() {
        return this.originalHandler;
    }

    public BackendNodeId getBackendNodeId() {
        return this.backendNodeId;
    }

    private static EventListener fromJson(JsonInput input) {
        String type = null;
        Boolean useCapture = null;
        Boolean passive = null;
        Boolean once = null;
        ScriptId scriptId = null;
        Integer lineNumber = null;
        Integer columnNumber = null;
        RemoteObject handler = null;
        RemoteObject originalHandler = null;
        BackendNodeId backendNodeId = null;
        input.beginObject();
        block24: while (input.hasNext()) {
            switch (input.nextName()) {
                case "type": {
                    type = input.nextString();
                    continue block24;
                }
                case "useCapture": {
                    useCapture = input.nextBoolean();
                    continue block24;
                }
                case "passive": {
                    passive = input.nextBoolean();
                    continue block24;
                }
                case "once": {
                    once = input.nextBoolean();
                    continue block24;
                }
                case "scriptId": {
                    scriptId = (ScriptId)input.read(ScriptId.class);
                    continue block24;
                }
                case "lineNumber": {
                    lineNumber = input.nextNumber().intValue();
                    continue block24;
                }
                case "columnNumber": {
                    columnNumber = input.nextNumber().intValue();
                    continue block24;
                }
                case "handler": {
                    handler = (RemoteObject)input.read(RemoteObject.class);
                    continue block24;
                }
                case "originalHandler": {
                    originalHandler = (RemoteObject)input.read(RemoteObject.class);
                    continue block24;
                }
                case "backendNodeId": {
                    backendNodeId = (BackendNodeId)input.read(BackendNodeId.class);
                    continue block24;
                }
            }
            input.skipValue();
        }
        input.endObject();
        return new EventListener(type, useCapture, passive, once, scriptId, lineNumber, columnNumber, handler, originalHandler, backendNodeId);
    }
}

