/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.devtools.debugger.model;

import java.util.Objects;
import org.openqa.selenium.devtools.runtime.model.ScriptId;
import org.openqa.selenium.json.JsonInput;

public class Location {
    private final ScriptId scriptId;
    private final Integer lineNumber;
    private final Integer columnNumber;

    public Location(ScriptId scriptId, Integer lineNumber, Integer columnNumber) {
        this.scriptId = Objects.requireNonNull(scriptId, "scriptId is required");
        this.lineNumber = Objects.requireNonNull(lineNumber, "lineNumber is required");
        this.columnNumber = columnNumber;
    }

    public ScriptId getScriptId() {
        return this.scriptId;
    }

    public Integer getLineNumber() {
        return this.lineNumber;
    }

    public Integer getColumnNumber() {
        return this.columnNumber;
    }

    private static Location fromJson(JsonInput input) {
        ScriptId scriptId = null;
        Integer lineNumber = null;
        Integer columnNumber = null;
        input.beginObject();
        block10: while (input.hasNext()) {
            switch (input.nextName()) {
                case "scriptId": {
                    scriptId = (ScriptId)input.read(ScriptId.class);
                    continue block10;
                }
                case "lineNumber": {
                    lineNumber = input.nextNumber().intValue();
                    continue block10;
                }
                case "columnNumber": {
                    columnNumber = input.nextNumber().intValue();
                    continue block10;
                }
            }
            input.skipValue();
        }
        input.endObject();
        return new Location(scriptId, lineNumber, columnNumber);
    }
}

