/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.devtools.css.model;

import com.google.common.reflect.TypeToken;
import java.util.List;
import java.util.Objects;
import org.openqa.selenium.devtools.css.model.CSSStyle;
import org.openqa.selenium.devtools.css.model.RuleMatch;
import org.openqa.selenium.json.JsonInput;

public class InheritedStyleEntry {
    private final CSSStyle inlineStyle;
    private final List<RuleMatch> matchedCSSRules;

    public InheritedStyleEntry(CSSStyle inlineStyle, List<RuleMatch> matchedCSSRules) {
        this.inlineStyle = inlineStyle;
        this.matchedCSSRules = Objects.requireNonNull(matchedCSSRules, "matchedCSSRules is required");
    }

    public CSSStyle getInlineStyle() {
        return this.inlineStyle;
    }

    public List<RuleMatch> getMatchedCSSRules() {
        return this.matchedCSSRules;
    }

    private static InheritedStyleEntry fromJson(JsonInput input) {
        CSSStyle inlineStyle = null;
        List matchedCSSRules = null;
        input.beginObject();
        block8: while (input.hasNext()) {
            switch (input.nextName()) {
                case "inlineStyle": {
                    inlineStyle = (CSSStyle)input.read(CSSStyle.class);
                    continue block8;
                }
                case "matchedCSSRules": {
                    matchedCSSRules = (List)input.read(new TypeToken<List<RuleMatch>>(){}.getType());
                    continue block8;
                }
            }
            input.skipValue();
        }
        input.endObject();
        return new InheritedStyleEntry(inlineStyle, matchedCSSRules);
    }
}

