/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.devtools.animation;

import com.google.common.collect.ImmutableMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.openqa.selenium.Beta;
import org.openqa.selenium.devtools.Command;
import org.openqa.selenium.devtools.ConverterFunctions;
import org.openqa.selenium.devtools.Event;
import org.openqa.selenium.devtools.runtime.model.RemoteObject;

@Beta
public class Animation {
    public static Command<Void> disable() {
        ImmutableMap.Builder params = ImmutableMap.builder();
        return new Command<Void>("Animation.disable", (Map<String, Object>)params.build());
    }

    public static Command<Void> enable() {
        ImmutableMap.Builder params = ImmutableMap.builder();
        return new Command<Void>("Animation.enable", (Map<String, Object>)params.build());
    }

    public static Command<Number> getCurrentTime(String id) {
        Objects.requireNonNull(id, "id is required");
        ImmutableMap.Builder params = ImmutableMap.builder();
        params.put((Object)"id", (Object)id);
        return new Command<Number>("Animation.getCurrentTime", (Map<String, Object>)params.build(), ConverterFunctions.map("currentTime", Number.class));
    }

    public static Command<Number> getPlaybackRate() {
        ImmutableMap.Builder params = ImmutableMap.builder();
        return new Command<Number>("Animation.getPlaybackRate", (Map<String, Object>)params.build(), ConverterFunctions.map("playbackRate", Number.class));
    }

    public static Command<Void> releaseAnimations(List<String> animations) {
        Objects.requireNonNull(animations, "animations is required");
        ImmutableMap.Builder params = ImmutableMap.builder();
        params.put((Object)"animations", animations);
        return new Command<Void>("Animation.releaseAnimations", (Map<String, Object>)params.build());
    }

    public static Command<RemoteObject> resolveAnimation(String animationId) {
        Objects.requireNonNull(animationId, "animationId is required");
        ImmutableMap.Builder params = ImmutableMap.builder();
        params.put((Object)"animationId", (Object)animationId);
        return new Command<RemoteObject>("Animation.resolveAnimation", (Map<String, Object>)params.build(), ConverterFunctions.map("remoteObject", RemoteObject.class));
    }

    public static Command<Void> seekAnimations(List<String> animations, Number currentTime) {
        Objects.requireNonNull(animations, "animations is required");
        Objects.requireNonNull(currentTime, "currentTime is required");
        ImmutableMap.Builder params = ImmutableMap.builder();
        params.put((Object)"animations", animations);
        params.put((Object)"currentTime", (Object)currentTime);
        return new Command<Void>("Animation.seekAnimations", (Map<String, Object>)params.build());
    }

    public static Command<Void> setPaused(List<String> animations, Boolean paused) {
        Objects.requireNonNull(animations, "animations is required");
        Objects.requireNonNull(paused, "paused is required");
        ImmutableMap.Builder params = ImmutableMap.builder();
        params.put((Object)"animations", animations);
        params.put((Object)"paused", (Object)paused);
        return new Command<Void>("Animation.setPaused", (Map<String, Object>)params.build());
    }

    public static Command<Void> setPlaybackRate(Number playbackRate) {
        Objects.requireNonNull(playbackRate, "playbackRate is required");
        ImmutableMap.Builder params = ImmutableMap.builder();
        params.put((Object)"playbackRate", (Object)playbackRate);
        return new Command<Void>("Animation.setPlaybackRate", (Map<String, Object>)params.build());
    }

    public static Command<Void> setTiming(String animationId, Number duration, Number delay) {
        Objects.requireNonNull(animationId, "animationId is required");
        Objects.requireNonNull(duration, "duration is required");
        Objects.requireNonNull(delay, "delay is required");
        ImmutableMap.Builder params = ImmutableMap.builder();
        params.put((Object)"animationId", (Object)animationId);
        params.put((Object)"duration", (Object)duration);
        params.put((Object)"delay", (Object)delay);
        return new Command<Void>("Animation.setTiming", (Map<String, Object>)params.build());
    }

    public static Event<String> animationCanceled() {
        return new Event<String>("Animation.animationCanceled", ConverterFunctions.map("id", String.class));
    }

    public static Event<String> animationCreated() {
        return new Event<String>("Animation.animationCreated", ConverterFunctions.map("id", String.class));
    }

    public static Event<org.openqa.selenium.devtools.animation.model.Animation> animationStarted() {
        return new Event<org.openqa.selenium.devtools.animation.model.Animation>("Animation.animationStarted", ConverterFunctions.map("animation", org.openqa.selenium.devtools.animation.model.Animation.class));
    }
}

