/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.devtools.accessibility.model;

import com.google.common.reflect.TypeToken;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.openqa.selenium.devtools.accessibility.model.AXRelatedNode;
import org.openqa.selenium.devtools.accessibility.model.AXValueSource;
import org.openqa.selenium.devtools.accessibility.model.AXValueType;
import org.openqa.selenium.json.JsonInput;

public class AXValue {
    private final AXValueType type;
    private final Map<String, Object> value;
    private final List<AXRelatedNode> relatedNodes;
    private final List<AXValueSource> sources;

    public AXValue(AXValueType type, Map<String, Object> value, List<AXRelatedNode> relatedNodes, List<AXValueSource> sources) {
        this.type = Objects.requireNonNull(type, "type is required");
        this.value = value;
        this.relatedNodes = relatedNodes;
        this.sources = sources;
    }

    public AXValueType getType() {
        return this.type;
    }

    public Map<String, Object> getValue() {
        return this.value;
    }

    public List<AXRelatedNode> getRelatedNodes() {
        return this.relatedNodes;
    }

    public List<AXValueSource> getSources() {
        return this.sources;
    }

    private static AXValue fromJson(JsonInput input) {
        AXValueType type = null;
        Map value = null;
        List relatedNodes = null;
        List sources = null;
        input.beginObject();
        block12: while (input.hasNext()) {
            switch (input.nextName()) {
                case "type": {
                    type = (AXValueType)((Object)input.read(AXValueType.class));
                    continue block12;
                }
                case "value": {
                    value = (Map)input.read(new TypeToken<Map<String, Object>>(){}.getType());
                    continue block12;
                }
                case "relatedNodes": {
                    relatedNodes = (List)input.read(new TypeToken<List<AXRelatedNode>>(){}.getType());
                    continue block12;
                }
                case "sources": {
                    sources = (List)input.read(new TypeToken<List<AXValueSource>>(){}.getType());
                    continue block12;
                }
            }
            input.skipValue();
        }
        input.endObject();
        return new AXValue(type, value, relatedNodes, sources);
    }
}

