/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.devtools.accessibility.model;

import com.google.common.reflect.TypeToken;
import java.util.List;
import java.util.Objects;
import org.openqa.selenium.devtools.accessibility.model.AXNodeId;
import org.openqa.selenium.devtools.accessibility.model.AXProperty;
import org.openqa.selenium.devtools.accessibility.model.AXValue;
import org.openqa.selenium.devtools.dom.model.BackendNodeId;
import org.openqa.selenium.json.JsonInput;

public class AXNode {
    private final AXNodeId nodeId;
    private final Boolean ignored;
    private final List<AXProperty> ignoredReasons;
    private final AXValue role;
    private final AXValue name;
    private final AXValue description;
    private final AXValue value;
    private final List<AXProperty> properties;
    private final List<AXNodeId> childIds;
    private final BackendNodeId backendDOMNodeId;

    public AXNode(AXNodeId nodeId, Boolean ignored, List<AXProperty> ignoredReasons, AXValue role, AXValue name, AXValue description, AXValue value, List<AXProperty> properties, List<AXNodeId> childIds, BackendNodeId backendDOMNodeId) {
        this.nodeId = Objects.requireNonNull(nodeId, "nodeId is required");
        this.ignored = Objects.requireNonNull(ignored, "ignored is required");
        this.ignoredReasons = ignoredReasons;
        this.role = role;
        this.name = name;
        this.description = description;
        this.value = value;
        this.properties = properties;
        this.childIds = childIds;
        this.backendDOMNodeId = backendDOMNodeId;
    }

    public AXNodeId getNodeId() {
        return this.nodeId;
    }

    public Boolean getIgnored() {
        return this.ignored;
    }

    public List<AXProperty> getIgnoredReasons() {
        return this.ignoredReasons;
    }

    public AXValue getRole() {
        return this.role;
    }

    public AXValue getName() {
        return this.name;
    }

    public AXValue getDescription() {
        return this.description;
    }

    public AXValue getValue() {
        return this.value;
    }

    public List<AXProperty> getProperties() {
        return this.properties;
    }

    public List<AXNodeId> getChildIds() {
        return this.childIds;
    }

    public BackendNodeId getBackendDOMNodeId() {
        return this.backendDOMNodeId;
    }

    private static AXNode fromJson(JsonInput input) {
        AXNodeId nodeId = null;
        Boolean ignored = null;
        List ignoredReasons = null;
        AXValue role = null;
        AXValue name = null;
        AXValue description = null;
        AXValue value = null;
        List properties = null;
        List childIds = null;
        BackendNodeId backendDOMNodeId = null;
        input.beginObject();
        block24: while (input.hasNext()) {
            switch (input.nextName()) {
                case "nodeId": {
                    nodeId = (AXNodeId)input.read(AXNodeId.class);
                    continue block24;
                }
                case "ignored": {
                    ignored = input.nextBoolean();
                    continue block24;
                }
                case "ignoredReasons": {
                    ignoredReasons = (List)input.read(new TypeToken<List<AXProperty>>(){}.getType());
                    continue block24;
                }
                case "role": {
                    role = (AXValue)input.read(AXValue.class);
                    continue block24;
                }
                case "name": {
                    name = (AXValue)input.read(AXValue.class);
                    continue block24;
                }
                case "description": {
                    description = (AXValue)input.read(AXValue.class);
                    continue block24;
                }
                case "value": {
                    value = (AXValue)input.read(AXValue.class);
                    continue block24;
                }
                case "properties": {
                    properties = (List)input.read(new TypeToken<List<AXProperty>>(){}.getType());
                    continue block24;
                }
                case "childIds": {
                    childIds = (List)input.read(new TypeToken<List<AXNodeId>>(){}.getType());
                    continue block24;
                }
                case "backendDOMNodeId": {
                    backendDOMNodeId = (BackendNodeId)input.read(BackendNodeId.class);
                    continue block24;
                }
            }
            input.skipValue();
        }
        input.endObject();
        return new AXNode(nodeId, ignored, ignoredReasons, role, name, description, value, properties, childIds, backendDOMNodeId);
    }
}

