/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.devtools.target;

import com.google.common.collect.ImmutableMap;
import com.google.common.reflect.TypeToken;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import org.openqa.selenium.Beta;
import org.openqa.selenium.devtools.Command;
import org.openqa.selenium.devtools.ConverterFunctions;
import org.openqa.selenium.devtools.Event;
import org.openqa.selenium.devtools.target.model.AttachToTarget;
import org.openqa.selenium.devtools.target.model.BrowserContextID;
import org.openqa.selenium.devtools.target.model.DetachedFromTarget;
import org.openqa.selenium.devtools.target.model.ReceivedMessageFromTarget;
import org.openqa.selenium.devtools.target.model.RemoteLocation;
import org.openqa.selenium.devtools.target.model.TargetCrashed;
import org.openqa.selenium.devtools.target.model.TargetId;
import org.openqa.selenium.devtools.target.model.TargetInfo;
import org.openqa.selenium.remote.SessionId;

public class Target {
    public static Command<Void> activateTarget(TargetId targetId) {
        Objects.requireNonNull(targetId, "Target ID must be set.");
        return new Command<Void>("Target.activateTarget", (Map<String, Object>)ImmutableMap.of((Object)"targetId", (Object)targetId));
    }

    @Beta
    public static Command<SessionId> attachToBrowserTarget() {
        return new Command<SessionId>("Target.attachToBrowserTarget", (Map<String, Object>)ImmutableMap.of(), ConverterFunctions.map("sessionId", SessionId.class));
    }

    public static Command<Boolean> closeTarget(TargetId targetId) {
        Objects.requireNonNull(targetId, "Target ID must be set.");
        return new Command<Boolean>("Target.closeTarget", (Map<String, Object>)ImmutableMap.of((Object)"targetId", (Object)targetId), ConverterFunctions.map("success", Boolean.class));
    }

    @Beta
    public static Command<Void> exposeDevToolsProtocol(TargetId targetId, Optional<String> bindingName) {
        Objects.requireNonNull(targetId, "Target ID must be set.");
        String bindingNameValue = bindingName.isPresent() ? bindingName.get() : "cdp";
        return new Command<Void>("Target.exposeDevToolsProtocol", (Map<String, Object>)ImmutableMap.of((Object)"targetId", (Object)targetId, (Object)"bindingName", (Object)bindingNameValue));
    }

    @Beta
    public static Command<BrowserContextID> createBrowserContext() {
        return new Command<BrowserContextID>("Target.createBrowserContext", (Map<String, Object>)ImmutableMap.of(), ConverterFunctions.map("browserContextId", BrowserContextID.class));
    }

    @Beta
    public static Command<List<BrowserContextID>> getBrowserContexts() {
        return new Command<List<BrowserContextID>>("Target.getBrowserContexts", (Map<String, Object>)ImmutableMap.of(), ConverterFunctions.map("browserContextIds", new TypeToken<List<BrowserContextID>>(){}.getType()));
    }

    public static Command<TargetId> createTarget(String url, Optional<Integer> width, Optional<Integer> height, Optional<BrowserContextID> browserContextId, Optional<Boolean> enableBeginFrameControl, Optional<Boolean> newWindow, Optional<Boolean> background) {
        Objects.requireNonNull(url, "Url is required");
        ImmutableMap.Builder params = ImmutableMap.builder();
        params.put((Object)"url", (Object)url);
        width.ifPresent(integer -> params.put((Object)"width", integer));
        height.ifPresent(integer -> params.put((Object)"height", integer));
        browserContextId.ifPresent(bid -> params.put((Object)"browserContextId", bid));
        enableBeginFrameControl.ifPresent(aBoolean -> params.put((Object)"enableBeginFrameControl", aBoolean));
        newWindow.ifPresent(aBoolean -> params.put((Object)"newWindow", aBoolean));
        background.ifPresent(aBoolean -> params.put((Object)"background", aBoolean));
        return new Command<TargetId>("Target.createTarget", (Map<String, Object>)params.build(), ConverterFunctions.map("targetId", TargetId.class));
    }

    public static Command<Void> detachFromTarget(Optional<SessionId> sessionId, Optional<TargetId> targetId) {
        ImmutableMap.Builder params = ImmutableMap.builder();
        sessionId.ifPresent(sessionID -> params.put((Object)"sessionId", sessionID));
        targetId.ifPresent(targetID -> params.put((Object)"targetId", targetID));
        return new Command<Void>("Target.detachFromTarget", (Map<String, Object>)params.build());
    }

    @Beta
    public static Command<Void> disposeBrowserContext(BrowserContextID browserContextID) {
        Objects.requireNonNull(browserContextID, "browserContextId is required");
        return new Command<Void>("Target.disposeBrowserContext", (Map<String, Object>)ImmutableMap.of((Object)"browserContextId", (Object)browserContextID));
    }

    @Beta
    public static Command<TargetInfo> getTargetInfo(Optional<TargetId> targetId) {
        ImmutableMap.Builder params = ImmutableMap.builder();
        targetId.ifPresent(targetID -> params.put((Object)"targetId", targetID));
        return new Command<TargetInfo>("Target.getTargetInfo", (Map<String, Object>)params.build(), ConverterFunctions.map("targetInfo", TargetInfo.class));
    }

    public static Command<Set<TargetInfo>> getTargets() {
        return new Command<Set<TargetInfo>>("Target.getTargets", (Map<String, Object>)ImmutableMap.of(), ConverterFunctions.map("targetInfos", new TypeToken<Set<TargetInfo>>(){}.getType()));
    }

    public static Command<Void> sendMessageToTarget(String message, Optional<SessionId> sessionID, @Deprecated Optional<TargetId> targetID) {
        Objects.requireNonNull(message, "message is required");
        ImmutableMap.Builder params = ImmutableMap.builder();
        params.put((Object)"message", (Object)message);
        sessionID.ifPresent(sessionId -> params.put((Object)"sessionId", sessionId));
        targetID.ifPresent(targetId -> params.put((Object)"targetId", targetId));
        return new Command<Void>("Target.sendMessageToTarget", (Map<String, Object>)params.build());
    }

    public static Command<SessionId> attachToTarget(TargetId targetId, Optional<Boolean> flatten) {
        Objects.requireNonNull(targetId, "Target ID must be set.");
        ImmutableMap.Builder params = ImmutableMap.builder();
        params.put((Object)"targetId", (Object)targetId);
        params.put((Object)"flatten", (Object)flatten.orElse(true));
        return new Command<SessionId>("Target.attachToTarget", (Map<String, Object>)params.build(), ConverterFunctions.map("sessionId", SessionId.class));
    }

    @Beta
    public static Command<Void> setAutoAttach(Boolean autoAttach, Boolean waitForDebuggerOnStart, Optional<Boolean> flatten) {
        Objects.requireNonNull(autoAttach, "autoAttach is required");
        Objects.requireNonNull(waitForDebuggerOnStart, "waitForDebuggerOnStart is required");
        ImmutableMap.Builder params = ImmutableMap.builder();
        params.put((Object)"autoAttach", (Object)autoAttach);
        params.put((Object)"waitForDebuggerOnStart", (Object)waitForDebuggerOnStart);
        flatten.ifPresent(aBoolean -> params.put((Object)"flatten", aBoolean));
        return new Command<Void>("Target.setAutoAttach", (Map<String, Object>)params.build());
    }

    public static Command<Void> setDiscoverTargets(boolean discover) {
        return new Command<Void>("Target.setDiscoverTargets", (Map<String, Object>)ImmutableMap.of((Object)"discover", (Object)discover));
    }

    @Beta
    public static Command<Void> setRemoteLocations(List<RemoteLocation> locations) {
        return new Command<Void>("Target.setRemoteLocations", (Map<String, Object>)ImmutableMap.of((Object)"locations", locations));
    }

    @Beta
    public static Event<AttachToTarget> attachedToTarget() {
        return new Event<AttachToTarget>("Target.attachedToTarget", ConverterFunctions.map("sessionId", AttachToTarget.class));
    }

    @Beta
    public static Event<DetachedFromTarget> detachedFromTarget() {
        return new Event<DetachedFromTarget>("Target.detachedFromTarget", input -> (DetachedFromTarget)input.read(DetachedFromTarget.class));
    }

    public static Event<ReceivedMessageFromTarget> receivedMessageFromTarget() {
        return new Event<ReceivedMessageFromTarget>("Target.receivedMessageFromTarget", ConverterFunctions.map("sessionId", ReceivedMessageFromTarget.class));
    }

    public static Event<TargetInfo> targetCreated() {
        return new Event<TargetInfo>("Target.targetDestroyed", ConverterFunctions.map("targetInfo", TargetInfo.class));
    }

    public static Event<TargetId> targetDestroyed() {
        return new Event<TargetId>("Target.targetDestroyed", ConverterFunctions.map("targetId", TargetId.class));
    }

    public static Event<TargetCrashed> targetCrashed() {
        return new Event<TargetCrashed>("Target.targetCrashed", ConverterFunctions.map("targetId", TargetCrashed.class));
    }

    public static Event<TargetInfo> targetInfoChanged() {
        return new Event<TargetInfo>("Target.targetInfoChanged", ConverterFunctions.map("targetInfo", TargetInfo.class));
    }
}

