/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.devtools;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.Objects;
import java.util.logging.Level;
import org.openqa.selenium.devtools.Command;
import org.openqa.selenium.devtools.ConverterFunctions;
import org.openqa.selenium.devtools.Event;
import org.openqa.selenium.devtools.network.model.MonotonicTime;
import org.openqa.selenium.json.JsonInput;

public class Log {
    private static final String DOMAIN_NAME = "Log";

    public static Command<Void> clear() {
        return new Command<Void>("Log.clear", (Map<String, Object>)ImmutableMap.of());
    }

    public static Command<Void> enable() {
        return new Command<Void>("Log.enable", (Map<String, Object>)ImmutableMap.of());
    }

    public static Command<Void> disable() {
        return new Command<Void>("Log.disable", (Map<String, Object>)ImmutableMap.of());
    }

    public static Event<LogEntry> entryAdded() {
        return new Event<LogEntry>("Log.entryAdded", ConverterFunctions.map("entry", LogEntry.class));
    }

    public static class LogEntry {
        private final String source;
        private final String level;
        private final String text;
        private final MonotonicTime timestamp;

        public LogEntry(String source, String level, String text, MonotonicTime timestamp) {
            this.source = Objects.requireNonNull(source);
            this.level = Objects.requireNonNull(level);
            this.text = Objects.requireNonNull(text);
            this.timestamp = Objects.requireNonNull(timestamp);
        }

        public String getSource() {
            return this.source;
        }

        public String getLevel() {
            return this.level;
        }

        public String getText() {
            return this.text;
        }

        public MonotonicTime getTimestamp() {
            return this.timestamp;
        }

        public org.openqa.selenium.logging.LogEntry asSeleniumLogEntry() {
            Level level;
            switch (this.getLevel()) {
                case "error": {
                    level = Level.SEVERE;
                    break;
                }
                case "verbose": {
                    level = Level.ALL;
                    break;
                }
                case "warning": {
                    level = Level.WARNING;
                    break;
                }
                default: {
                    level = Level.INFO;
                }
            }
            return new org.openqa.selenium.logging.LogEntry(level, this.timestamp.getTimeStamp().toEpochMilli(), this.getText());
        }

        private Map<String, Object> toJson() {
            return ImmutableMap.of((Object)"source", (Object)this.getSource(), (Object)"level", (Object)this.getLevel(), (Object)"text", (Object)this.getText(), (Object)"timestamp", (Object)this.getTimestamp());
        }

        private static LogEntry fromJson(JsonInput input) {
            String source = null;
            String level = null;
            String text = null;
            MonotonicTime timestamp = null;
            input.beginObject();
            block12: while (input.hasNext()) {
                switch (input.nextName()) {
                    case "level": {
                        level = input.nextString();
                        continue block12;
                    }
                    case "source": {
                        source = input.nextString();
                        continue block12;
                    }
                    case "text": {
                        text = input.nextString();
                        continue block12;
                    }
                    case "timestamp": {
                        timestamp = MonotonicTime.parse(input.nextNumber());
                        continue block12;
                    }
                }
                input.skipValue();
            }
            input.endObject();
            return new LogEntry(source, level, text, timestamp);
        }
    }
}

