/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.devtools.v99.runtime.model;

import java.util.Objects;
import org.openqa.selenium.devtools.v99.runtime.model.ScriptId;
import org.openqa.selenium.json.JsonInput;

public class CallFrame {
    private final String functionName;
    private final ScriptId scriptId;
    private final String url;
    private final Integer lineNumber;
    private final Integer columnNumber;

    public CallFrame(String functionName, ScriptId scriptId, String url, Integer lineNumber, Integer columnNumber) {
        this.functionName = Objects.requireNonNull(functionName, "functionName is required");
        this.scriptId = Objects.requireNonNull(scriptId, "scriptId is required");
        this.url = Objects.requireNonNull(url, "url is required");
        this.lineNumber = Objects.requireNonNull(lineNumber, "lineNumber is required");
        this.columnNumber = Objects.requireNonNull(columnNumber, "columnNumber is required");
    }

    public String getFunctionName() {
        return this.functionName;
    }

    public ScriptId getScriptId() {
        return this.scriptId;
    }

    public String getUrl() {
        return this.url;
    }

    public Integer getLineNumber() {
        return this.lineNumber;
    }

    public Integer getColumnNumber() {
        return this.columnNumber;
    }

    private static CallFrame fromJson(JsonInput input) {
        String functionName = null;
        ScriptId scriptId = null;
        String url = null;
        Integer lineNumber = 0;
        Integer columnNumber = 0;
        input.beginObject();
        block14: while (input.hasNext()) {
            switch (input.nextName()) {
                case "functionName": {
                    functionName = input.nextString();
                    continue block14;
                }
                case "scriptId": {
                    scriptId = (ScriptId)input.read(ScriptId.class);
                    continue block14;
                }
                case "url": {
                    url = input.nextString();
                    continue block14;
                }
                case "lineNumber": {
                    lineNumber = input.nextNumber().intValue();
                    continue block14;
                }
                case "columnNumber": {
                    columnNumber = input.nextNumber().intValue();
                    continue block14;
                }
            }
            input.skipValue();
        }
        input.endObject();
        return new CallFrame(functionName, scriptId, url, lineNumber, columnNumber);
    }
}

