package org.openqa.selenium.devtools.v99.runtime.model;

import org.openqa.selenium.Beta;
import org.openqa.selenium.json.JsonInput;

/**
 * Object private field descriptor.
 */
@org.openqa.selenium.Beta()
public class PrivatePropertyDescriptor {

    private final java.lang.String name;

    private final java.util.Optional<org.openqa.selenium.devtools.v99.runtime.model.RemoteObject> value;

    private final java.util.Optional<org.openqa.selenium.devtools.v99.runtime.model.RemoteObject> get;

    private final java.util.Optional<org.openqa.selenium.devtools.v99.runtime.model.RemoteObject> set;

    public PrivatePropertyDescriptor(java.lang.String name, java.util.Optional<org.openqa.selenium.devtools.v99.runtime.model.RemoteObject> value, java.util.Optional<org.openqa.selenium.devtools.v99.runtime.model.RemoteObject> get, java.util.Optional<org.openqa.selenium.devtools.v99.runtime.model.RemoteObject> set) {
        this.name = java.util.Objects.requireNonNull(name, "name is required");
        this.value = value;
        this.get = get;
        this.set = set;
    }

    /**
     * Private property name.
     */
    public java.lang.String getName() {
        return name;
    }

    /**
     * The value associated with the private property.
     */
    public java.util.Optional<org.openqa.selenium.devtools.v99.runtime.model.RemoteObject> getValue() {
        return value;
    }

    /**
     * A function which serves as a getter for the private property,
     * or `undefined` if there is no getter (accessor descriptors only).
     */
    public java.util.Optional<org.openqa.selenium.devtools.v99.runtime.model.RemoteObject> getGet() {
        return get;
    }

    /**
     * A function which serves as a setter for the private property,
     * or `undefined` if there is no setter (accessor descriptors only).
     */
    public java.util.Optional<org.openqa.selenium.devtools.v99.runtime.model.RemoteObject> getSet() {
        return set;
    }

    private static PrivatePropertyDescriptor fromJson(JsonInput input) {
        java.lang.String name = null;
        java.util.Optional<org.openqa.selenium.devtools.v99.runtime.model.RemoteObject> value = java.util.Optional.empty();
        java.util.Optional<org.openqa.selenium.devtools.v99.runtime.model.RemoteObject> get = java.util.Optional.empty();
        java.util.Optional<org.openqa.selenium.devtools.v99.runtime.model.RemoteObject> set = java.util.Optional.empty();
        input.beginObject();
        while (input.hasNext()) {
            switch(input.nextName()) {
                case "name":
                    name = input.nextString();
                    break;
                case "value":
                    value = java.util.Optional.ofNullable(input.read(org.openqa.selenium.devtools.v99.runtime.model.RemoteObject.class));
                    break;
                case "get":
                    get = java.util.Optional.ofNullable(input.read(org.openqa.selenium.devtools.v99.runtime.model.RemoteObject.class));
                    break;
                case "set":
                    set = java.util.Optional.ofNullable(input.read(org.openqa.selenium.devtools.v99.runtime.model.RemoteObject.class));
                    break;
                default:
                    input.skipValue();
                    break;
            }
        }
        input.endObject();
        return new PrivatePropertyDescriptor(name, value, get, set);
    }
}
