/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.devtools.v99.security.model;

import java.util.Arrays;
import org.openqa.selenium.devtools.DevToolsException;
import org.openqa.selenium.json.JsonInput;

public enum MixedContentType {
    BLOCKABLE("blockable"),
    OPTIONALLY_BLOCKABLE("optionally-blockable"),
    NONE("none");

    private String value;

    private MixedContentType(String value) {
        this.value = value;
    }

    public static MixedContentType fromString(String s) {
        return Arrays.stream(MixedContentType.values()).filter(rs -> rs.value.equalsIgnoreCase(s)).findFirst().orElseThrow(() -> new DevToolsException("Given value " + s + " is not found within MixedContentType "));
    }

    public String toString() {
        return this.value;
    }

    public String toJson() {
        return this.value;
    }

    private static MixedContentType fromJson(JsonInput input) {
        return MixedContentType.fromString(input.nextString());
    }
}

