package org.openqa.selenium.devtools.v99.webaudio.model;

import org.openqa.selenium.Beta;
import org.openqa.selenium.json.JsonInput;

/**
 * Notifies that AudioNodes are disconnected. The destination can be null, and it means all the outgoing connections from the source are disconnected.
 */
public class NodesDisconnected {

    private final org.openqa.selenium.devtools.v99.webaudio.model.GraphObjectId contextId;

    private final org.openqa.selenium.devtools.v99.webaudio.model.GraphObjectId sourceId;

    private final org.openqa.selenium.devtools.v99.webaudio.model.GraphObjectId destinationId;

    private final java.util.Optional<java.lang.Number> sourceOutputIndex;

    private final java.util.Optional<java.lang.Number> destinationInputIndex;

    public NodesDisconnected(org.openqa.selenium.devtools.v99.webaudio.model.GraphObjectId contextId, org.openqa.selenium.devtools.v99.webaudio.model.GraphObjectId sourceId, org.openqa.selenium.devtools.v99.webaudio.model.GraphObjectId destinationId, java.util.Optional<java.lang.Number> sourceOutputIndex, java.util.Optional<java.lang.Number> destinationInputIndex) {
        this.contextId = java.util.Objects.requireNonNull(contextId, "contextId is required");
        this.sourceId = java.util.Objects.requireNonNull(sourceId, "sourceId is required");
        this.destinationId = java.util.Objects.requireNonNull(destinationId, "destinationId is required");
        this.sourceOutputIndex = sourceOutputIndex;
        this.destinationInputIndex = destinationInputIndex;
    }

    public org.openqa.selenium.devtools.v99.webaudio.model.GraphObjectId getContextId() {
        return contextId;
    }

    public org.openqa.selenium.devtools.v99.webaudio.model.GraphObjectId getSourceId() {
        return sourceId;
    }

    public org.openqa.selenium.devtools.v99.webaudio.model.GraphObjectId getDestinationId() {
        return destinationId;
    }

    public java.util.Optional<java.lang.Number> getSourceOutputIndex() {
        return sourceOutputIndex;
    }

    public java.util.Optional<java.lang.Number> getDestinationInputIndex() {
        return destinationInputIndex;
    }

    private static NodesDisconnected fromJson(JsonInput input) {
        org.openqa.selenium.devtools.v99.webaudio.model.GraphObjectId contextId = null;
        org.openqa.selenium.devtools.v99.webaudio.model.GraphObjectId sourceId = null;
        org.openqa.selenium.devtools.v99.webaudio.model.GraphObjectId destinationId = null;
        java.util.Optional<java.lang.Number> sourceOutputIndex = java.util.Optional.empty();
        java.util.Optional<java.lang.Number> destinationInputIndex = java.util.Optional.empty();
        input.beginObject();
        while (input.hasNext()) {
            switch(input.nextName()) {
                case "contextId":
                    contextId = input.read(org.openqa.selenium.devtools.v99.webaudio.model.GraphObjectId.class);
                    break;
                case "sourceId":
                    sourceId = input.read(org.openqa.selenium.devtools.v99.webaudio.model.GraphObjectId.class);
                    break;
                case "destinationId":
                    destinationId = input.read(org.openqa.selenium.devtools.v99.webaudio.model.GraphObjectId.class);
                    break;
                case "sourceOutputIndex":
                    sourceOutputIndex = java.util.Optional.ofNullable(input.nextNumber());
                    break;
                case "destinationInputIndex":
                    destinationInputIndex = java.util.Optional.ofNullable(input.nextNumber());
                    break;
                default:
                    input.skipValue();
                    break;
            }
        }
        input.endObject();
        return new NodesDisconnected(contextId, sourceId, destinationId, sourceOutputIndex, destinationInputIndex);
    }
}
