package org.openqa.selenium.devtools.v98.overlay.model;

import org.openqa.selenium.Beta;
import org.openqa.selenium.json.JsonInput;

public class ContainerQueryHighlightConfig {

    private final org.openqa.selenium.devtools.v98.overlay.model.ContainerQueryContainerHighlightConfig containerQueryContainerHighlightConfig;

    private final org.openqa.selenium.devtools.v98.dom.model.NodeId nodeId;

    public ContainerQueryHighlightConfig(org.openqa.selenium.devtools.v98.overlay.model.ContainerQueryContainerHighlightConfig containerQueryContainerHighlightConfig, org.openqa.selenium.devtools.v98.dom.model.NodeId nodeId) {
        this.containerQueryContainerHighlightConfig = java.util.Objects.requireNonNull(containerQueryContainerHighlightConfig, "containerQueryContainerHighlightConfig is required");
        this.nodeId = java.util.Objects.requireNonNull(nodeId, "nodeId is required");
    }

    /**
     * A descriptor for the highlight appearance of container query containers.
     */
    public org.openqa.selenium.devtools.v98.overlay.model.ContainerQueryContainerHighlightConfig getContainerQueryContainerHighlightConfig() {
        return containerQueryContainerHighlightConfig;
    }

    /**
     * Identifier of the container node to highlight.
     */
    public org.openqa.selenium.devtools.v98.dom.model.NodeId getNodeId() {
        return nodeId;
    }

    private static ContainerQueryHighlightConfig fromJson(JsonInput input) {
        org.openqa.selenium.devtools.v98.overlay.model.ContainerQueryContainerHighlightConfig containerQueryContainerHighlightConfig = null;
        org.openqa.selenium.devtools.v98.dom.model.NodeId nodeId = null;
        input.beginObject();
        while (input.hasNext()) {
            switch(input.nextName()) {
                case "containerQueryContainerHighlightConfig":
                    containerQueryContainerHighlightConfig = input.read(org.openqa.selenium.devtools.v98.overlay.model.ContainerQueryContainerHighlightConfig.class);
                    break;
                case "nodeId":
                    nodeId = input.read(org.openqa.selenium.devtools.v98.dom.model.NodeId.class);
                    break;
                default:
                    input.skipValue();
                    break;
            }
        }
        input.endObject();
        return new ContainerQueryHighlightConfig(containerQueryContainerHighlightConfig, nodeId);
    }
}
