package org.openqa.selenium.devtools.v97.page.model;

import org.openqa.selenium.Beta;
import org.openqa.selenium.json.JsonInput;

/**
 * Reason for a permissions policy feature to be disabled.
 */
@org.openqa.selenium.Beta()
public enum PermissionsPolicyBlockReason {

    HEADER("Header"), IFRAMEATTRIBUTE("IframeAttribute");

    private String value;

    PermissionsPolicyBlockReason(String value) {
        this.value = value;
    }

    public static PermissionsPolicyBlockReason fromString(String s) {
        return java.util.Arrays.stream(PermissionsPolicyBlockReason.values()).filter(rs -> rs.value.equalsIgnoreCase(s)).findFirst().orElseThrow(() -> new org.openqa.selenium.devtools.DevToolsException("Given value " + s + " is not found within PermissionsPolicyBlockReason "));
    }

    public String toString() {
        return value;
    }

    public String toJson() {
        return value;
    }

    private static PermissionsPolicyBlockReason fromJson(JsonInput input) {
        return fromString(input.nextString());
    }
}
