/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.devtools.v97.page.model;

import java.util.Objects;
import java.util.Optional;
import org.openqa.selenium.devtools.v97.page.model.FrameId;
import org.openqa.selenium.devtools.v97.runtime.model.StackTrace;
import org.openqa.selenium.json.JsonInput;

public class FrameAttached {
    private final FrameId frameId;
    private final FrameId parentFrameId;
    private final Optional<StackTrace> stack;

    public FrameAttached(FrameId frameId, FrameId parentFrameId, Optional<StackTrace> stack) {
        this.frameId = Objects.requireNonNull(frameId, "frameId is required");
        this.parentFrameId = Objects.requireNonNull(parentFrameId, "parentFrameId is required");
        this.stack = stack;
    }

    public FrameId getFrameId() {
        return this.frameId;
    }

    public FrameId getParentFrameId() {
        return this.parentFrameId;
    }

    public Optional<StackTrace> getStack() {
        return this.stack;
    }

    private static FrameAttached fromJson(JsonInput input) {
        FrameId frameId = null;
        FrameId parentFrameId = null;
        Optional<StackTrace> stack = Optional.empty();
        input.beginObject();
        block10: while (input.hasNext()) {
            switch (input.nextName()) {
                case "frameId": {
                    frameId = (FrameId)input.read(FrameId.class);
                    continue block10;
                }
                case "parentFrameId": {
                    parentFrameId = (FrameId)input.read(FrameId.class);
                    continue block10;
                }
                case "stack": {
                    stack = Optional.ofNullable((StackTrace)input.read(StackTrace.class));
                    continue block10;
                }
            }
            input.skipValue();
        }
        input.endObject();
        return new FrameAttached(frameId, parentFrameId, stack);
    }
}

