package org.openqa.selenium.devtools.v97.network.model;

import org.openqa.selenium.Beta;
import org.openqa.selenium.json.JsonInput;

@org.openqa.selenium.Beta()
public enum PrivateNetworkRequestPolicy {

    ALLOW("Allow"), BLOCKFROMINSECURETOMOREPRIVATE("BlockFromInsecureToMorePrivate"), WARNFROMINSECURETOMOREPRIVATE("WarnFromInsecureToMorePrivate"), PREFLIGHTBLOCK("PreflightBlock"), PREFLIGHTWARN("PreflightWarn");

    private String value;

    PrivateNetworkRequestPolicy(String value) {
        this.value = value;
    }

    public static PrivateNetworkRequestPolicy fromString(String s) {
        return java.util.Arrays.stream(PrivateNetworkRequestPolicy.values()).filter(rs -> rs.value.equalsIgnoreCase(s)).findFirst().orElseThrow(() -> new org.openqa.selenium.devtools.DevToolsException("Given value " + s + " is not found within PrivateNetworkRequestPolicy "));
    }

    public String toString() {
        return value;
    }

    public String toJson() {
        return value;
    }

    private static PrivateNetworkRequestPolicy fromJson(JsonInput input) {
        return fromString(input.nextString());
    }
}
