package org.openqa.selenium.devtools.v96.input.model;

import org.openqa.selenium.Beta;
import org.openqa.selenium.json.JsonInput;

public enum MouseButton {

    NONE("none"),
    LEFT("left"),
    MIDDLE("middle"),
    RIGHT("right"),
    BACK("back"),
    FORWARD("forward");

    private String value;

    MouseButton(String value) {
        this.value = value;
    }

    public static MouseButton fromString(String s) {
        return java.util.Arrays.stream(MouseButton.values()).filter(rs -> rs.value.equalsIgnoreCase(s)).findFirst().orElseThrow(() -> new org.openqa.selenium.devtools.DevToolsException("Given value " + s + " is not found within MouseButton "));
    }

    public String toString() {
        return value;
    }

    public String toJson() {
        return value;
    }

    private static MouseButton fromJson(JsonInput input) {
        return fromString(input.nextString());
    }
}
