package org.openqa.selenium.devtools.v96.overlay.model;

import org.openqa.selenium.Beta;
import org.openqa.selenium.json.JsonInput;

/**
 * Configuration data for the highlighting of Grid elements.
 */
public class GridHighlightConfig {

    private final java.util.Optional<java.lang.Boolean> showGridExtensionLines;

    private final java.util.Optional<java.lang.Boolean> showPositiveLineNumbers;

    private final java.util.Optional<java.lang.Boolean> showNegativeLineNumbers;

    private final java.util.Optional<java.lang.Boolean> showAreaNames;

    private final java.util.Optional<java.lang.Boolean> showLineNames;

    private final java.util.Optional<java.lang.Boolean> showTrackSizes;

    private final java.util.Optional<org.openqa.selenium.devtools.v96.dom.model.RGBA> gridBorderColor;

    private final java.util.Optional<org.openqa.selenium.devtools.v96.dom.model.RGBA> cellBorderColor;

    private final java.util.Optional<org.openqa.selenium.devtools.v96.dom.model.RGBA> rowLineColor;

    private final java.util.Optional<org.openqa.selenium.devtools.v96.dom.model.RGBA> columnLineColor;

    private final java.util.Optional<java.lang.Boolean> gridBorderDash;

    private final java.util.Optional<java.lang.Boolean> cellBorderDash;

    private final java.util.Optional<java.lang.Boolean> rowLineDash;

    private final java.util.Optional<java.lang.Boolean> columnLineDash;

    private final java.util.Optional<org.openqa.selenium.devtools.v96.dom.model.RGBA> rowGapColor;

    private final java.util.Optional<org.openqa.selenium.devtools.v96.dom.model.RGBA> rowHatchColor;

    private final java.util.Optional<org.openqa.selenium.devtools.v96.dom.model.RGBA> columnGapColor;

    private final java.util.Optional<org.openqa.selenium.devtools.v96.dom.model.RGBA> columnHatchColor;

    private final java.util.Optional<org.openqa.selenium.devtools.v96.dom.model.RGBA> areaBorderColor;

    private final java.util.Optional<org.openqa.selenium.devtools.v96.dom.model.RGBA> gridBackgroundColor;

    public GridHighlightConfig(java.util.Optional<java.lang.Boolean> showGridExtensionLines, java.util.Optional<java.lang.Boolean> showPositiveLineNumbers, java.util.Optional<java.lang.Boolean> showNegativeLineNumbers, java.util.Optional<java.lang.Boolean> showAreaNames, java.util.Optional<java.lang.Boolean> showLineNames, java.util.Optional<java.lang.Boolean> showTrackSizes, java.util.Optional<org.openqa.selenium.devtools.v96.dom.model.RGBA> gridBorderColor, java.util.Optional<org.openqa.selenium.devtools.v96.dom.model.RGBA> cellBorderColor, java.util.Optional<org.openqa.selenium.devtools.v96.dom.model.RGBA> rowLineColor, java.util.Optional<org.openqa.selenium.devtools.v96.dom.model.RGBA> columnLineColor, java.util.Optional<java.lang.Boolean> gridBorderDash, java.util.Optional<java.lang.Boolean> cellBorderDash, java.util.Optional<java.lang.Boolean> rowLineDash, java.util.Optional<java.lang.Boolean> columnLineDash, java.util.Optional<org.openqa.selenium.devtools.v96.dom.model.RGBA> rowGapColor, java.util.Optional<org.openqa.selenium.devtools.v96.dom.model.RGBA> rowHatchColor, java.util.Optional<org.openqa.selenium.devtools.v96.dom.model.RGBA> columnGapColor, java.util.Optional<org.openqa.selenium.devtools.v96.dom.model.RGBA> columnHatchColor, java.util.Optional<org.openqa.selenium.devtools.v96.dom.model.RGBA> areaBorderColor, java.util.Optional<org.openqa.selenium.devtools.v96.dom.model.RGBA> gridBackgroundColor) {
        this.showGridExtensionLines = showGridExtensionLines;
        this.showPositiveLineNumbers = showPositiveLineNumbers;
        this.showNegativeLineNumbers = showNegativeLineNumbers;
        this.showAreaNames = showAreaNames;
        this.showLineNames = showLineNames;
        this.showTrackSizes = showTrackSizes;
        this.gridBorderColor = gridBorderColor;
        this.cellBorderColor = cellBorderColor;
        this.rowLineColor = rowLineColor;
        this.columnLineColor = columnLineColor;
        this.gridBorderDash = gridBorderDash;
        this.cellBorderDash = cellBorderDash;
        this.rowLineDash = rowLineDash;
        this.columnLineDash = columnLineDash;
        this.rowGapColor = rowGapColor;
        this.rowHatchColor = rowHatchColor;
        this.columnGapColor = columnGapColor;
        this.columnHatchColor = columnHatchColor;
        this.areaBorderColor = areaBorderColor;
        this.gridBackgroundColor = gridBackgroundColor;
    }

    /**
     * Whether the extension lines from grid cells to the rulers should be shown (default: false).
     */
    public java.util.Optional<java.lang.Boolean> getShowGridExtensionLines() {
        return showGridExtensionLines;
    }

    /**
     * Show Positive line number labels (default: false).
     */
    public java.util.Optional<java.lang.Boolean> getShowPositiveLineNumbers() {
        return showPositiveLineNumbers;
    }

    /**
     * Show Negative line number labels (default: false).
     */
    public java.util.Optional<java.lang.Boolean> getShowNegativeLineNumbers() {
        return showNegativeLineNumbers;
    }

    /**
     * Show area name labels (default: false).
     */
    public java.util.Optional<java.lang.Boolean> getShowAreaNames() {
        return showAreaNames;
    }

    /**
     * Show line name labels (default: false).
     */
    public java.util.Optional<java.lang.Boolean> getShowLineNames() {
        return showLineNames;
    }

    /**
     * Show track size labels (default: false).
     */
    public java.util.Optional<java.lang.Boolean> getShowTrackSizes() {
        return showTrackSizes;
    }

    /**
     * The grid container border highlight color (default: transparent).
     */
    public java.util.Optional<org.openqa.selenium.devtools.v96.dom.model.RGBA> getGridBorderColor() {
        return gridBorderColor;
    }

    /**
     * The cell border color (default: transparent). Deprecated, please use rowLineColor and columnLineColor instead.
     */
    @Deprecated()
    public java.util.Optional<org.openqa.selenium.devtools.v96.dom.model.RGBA> getCellBorderColor() {
        return cellBorderColor;
    }

    /**
     * The row line color (default: transparent).
     */
    public java.util.Optional<org.openqa.selenium.devtools.v96.dom.model.RGBA> getRowLineColor() {
        return rowLineColor;
    }

    /**
     * The column line color (default: transparent).
     */
    public java.util.Optional<org.openqa.selenium.devtools.v96.dom.model.RGBA> getColumnLineColor() {
        return columnLineColor;
    }

    /**
     * Whether the grid border is dashed (default: false).
     */
    public java.util.Optional<java.lang.Boolean> getGridBorderDash() {
        return gridBorderDash;
    }

    /**
     * Whether the cell border is dashed (default: false). Deprecated, please us rowLineDash and columnLineDash instead.
     */
    @Deprecated()
    public java.util.Optional<java.lang.Boolean> getCellBorderDash() {
        return cellBorderDash;
    }

    /**
     * Whether row lines are dashed (default: false).
     */
    public java.util.Optional<java.lang.Boolean> getRowLineDash() {
        return rowLineDash;
    }

    /**
     * Whether column lines are dashed (default: false).
     */
    public java.util.Optional<java.lang.Boolean> getColumnLineDash() {
        return columnLineDash;
    }

    /**
     * The row gap highlight fill color (default: transparent).
     */
    public java.util.Optional<org.openqa.selenium.devtools.v96.dom.model.RGBA> getRowGapColor() {
        return rowGapColor;
    }

    /**
     * The row gap hatching fill color (default: transparent).
     */
    public java.util.Optional<org.openqa.selenium.devtools.v96.dom.model.RGBA> getRowHatchColor() {
        return rowHatchColor;
    }

    /**
     * The column gap highlight fill color (default: transparent).
     */
    public java.util.Optional<org.openqa.selenium.devtools.v96.dom.model.RGBA> getColumnGapColor() {
        return columnGapColor;
    }

    /**
     * The column gap hatching fill color (default: transparent).
     */
    public java.util.Optional<org.openqa.selenium.devtools.v96.dom.model.RGBA> getColumnHatchColor() {
        return columnHatchColor;
    }

    /**
     * The named grid areas border color (Default: transparent).
     */
    public java.util.Optional<org.openqa.selenium.devtools.v96.dom.model.RGBA> getAreaBorderColor() {
        return areaBorderColor;
    }

    /**
     * The grid container background color (Default: transparent).
     */
    public java.util.Optional<org.openqa.selenium.devtools.v96.dom.model.RGBA> getGridBackgroundColor() {
        return gridBackgroundColor;
    }

    private static GridHighlightConfig fromJson(JsonInput input) {
        java.util.Optional<java.lang.Boolean> showGridExtensionLines = java.util.Optional.empty();
        java.util.Optional<java.lang.Boolean> showPositiveLineNumbers = java.util.Optional.empty();
        java.util.Optional<java.lang.Boolean> showNegativeLineNumbers = java.util.Optional.empty();
        java.util.Optional<java.lang.Boolean> showAreaNames = java.util.Optional.empty();
        java.util.Optional<java.lang.Boolean> showLineNames = java.util.Optional.empty();
        java.util.Optional<java.lang.Boolean> showTrackSizes = java.util.Optional.empty();
        java.util.Optional<org.openqa.selenium.devtools.v96.dom.model.RGBA> gridBorderColor = java.util.Optional.empty();
        java.util.Optional<org.openqa.selenium.devtools.v96.dom.model.RGBA> cellBorderColor = java.util.Optional.empty();
        java.util.Optional<org.openqa.selenium.devtools.v96.dom.model.RGBA> rowLineColor = java.util.Optional.empty();
        java.util.Optional<org.openqa.selenium.devtools.v96.dom.model.RGBA> columnLineColor = java.util.Optional.empty();
        java.util.Optional<java.lang.Boolean> gridBorderDash = java.util.Optional.empty();
        java.util.Optional<java.lang.Boolean> cellBorderDash = java.util.Optional.empty();
        java.util.Optional<java.lang.Boolean> rowLineDash = java.util.Optional.empty();
        java.util.Optional<java.lang.Boolean> columnLineDash = java.util.Optional.empty();
        java.util.Optional<org.openqa.selenium.devtools.v96.dom.model.RGBA> rowGapColor = java.util.Optional.empty();
        java.util.Optional<org.openqa.selenium.devtools.v96.dom.model.RGBA> rowHatchColor = java.util.Optional.empty();
        java.util.Optional<org.openqa.selenium.devtools.v96.dom.model.RGBA> columnGapColor = java.util.Optional.empty();
        java.util.Optional<org.openqa.selenium.devtools.v96.dom.model.RGBA> columnHatchColor = java.util.Optional.empty();
        java.util.Optional<org.openqa.selenium.devtools.v96.dom.model.RGBA> areaBorderColor = java.util.Optional.empty();
        java.util.Optional<org.openqa.selenium.devtools.v96.dom.model.RGBA> gridBackgroundColor = java.util.Optional.empty();
        input.beginObject();
        while (input.hasNext()) {
            switch(input.nextName()) {
                case "showGridExtensionLines":
                    showGridExtensionLines = java.util.Optional.ofNullable(input.nextBoolean());
                    break;
                case "showPositiveLineNumbers":
                    showPositiveLineNumbers = java.util.Optional.ofNullable(input.nextBoolean());
                    break;
                case "showNegativeLineNumbers":
                    showNegativeLineNumbers = java.util.Optional.ofNullable(input.nextBoolean());
                    break;
                case "showAreaNames":
                    showAreaNames = java.util.Optional.ofNullable(input.nextBoolean());
                    break;
                case "showLineNames":
                    showLineNames = java.util.Optional.ofNullable(input.nextBoolean());
                    break;
                case "showTrackSizes":
                    showTrackSizes = java.util.Optional.ofNullable(input.nextBoolean());
                    break;
                case "gridBorderColor":
                    gridBorderColor = java.util.Optional.ofNullable(input.read(org.openqa.selenium.devtools.v96.dom.model.RGBA.class));
                    break;
                case "cellBorderColor":
                    cellBorderColor = java.util.Optional.ofNullable(input.read(org.openqa.selenium.devtools.v96.dom.model.RGBA.class));
                    break;
                case "rowLineColor":
                    rowLineColor = java.util.Optional.ofNullable(input.read(org.openqa.selenium.devtools.v96.dom.model.RGBA.class));
                    break;
                case "columnLineColor":
                    columnLineColor = java.util.Optional.ofNullable(input.read(org.openqa.selenium.devtools.v96.dom.model.RGBA.class));
                    break;
                case "gridBorderDash":
                    gridBorderDash = java.util.Optional.ofNullable(input.nextBoolean());
                    break;
                case "cellBorderDash":
                    cellBorderDash = java.util.Optional.ofNullable(input.nextBoolean());
                    break;
                case "rowLineDash":
                    rowLineDash = java.util.Optional.ofNullable(input.nextBoolean());
                    break;
                case "columnLineDash":
                    columnLineDash = java.util.Optional.ofNullable(input.nextBoolean());
                    break;
                case "rowGapColor":
                    rowGapColor = java.util.Optional.ofNullable(input.read(org.openqa.selenium.devtools.v96.dom.model.RGBA.class));
                    break;
                case "rowHatchColor":
                    rowHatchColor = java.util.Optional.ofNullable(input.read(org.openqa.selenium.devtools.v96.dom.model.RGBA.class));
                    break;
                case "columnGapColor":
                    columnGapColor = java.util.Optional.ofNullable(input.read(org.openqa.selenium.devtools.v96.dom.model.RGBA.class));
                    break;
                case "columnHatchColor":
                    columnHatchColor = java.util.Optional.ofNullable(input.read(org.openqa.selenium.devtools.v96.dom.model.RGBA.class));
                    break;
                case "areaBorderColor":
                    areaBorderColor = java.util.Optional.ofNullable(input.read(org.openqa.selenium.devtools.v96.dom.model.RGBA.class));
                    break;
                case "gridBackgroundColor":
                    gridBackgroundColor = java.util.Optional.ofNullable(input.read(org.openqa.selenium.devtools.v96.dom.model.RGBA.class));
                    break;
                default:
                    input.skipValue();
                    break;
            }
        }
        input.endObject();
        return new GridHighlightConfig(showGridExtensionLines, showPositiveLineNumbers, showNegativeLineNumbers, showAreaNames, showLineNames, showTrackSizes, gridBorderColor, cellBorderColor, rowLineColor, columnLineColor, gridBorderDash, cellBorderDash, rowLineDash, columnLineDash, rowGapColor, rowHatchColor, columnGapColor, columnHatchColor, areaBorderColor, gridBackgroundColor);
    }
}
