/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.devtools.v94.backgroundservice;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.Objects;
import org.openqa.selenium.Beta;
import org.openqa.selenium.devtools.Command;
import org.openqa.selenium.devtools.ConverterFunctions;
import org.openqa.selenium.devtools.Event;
import org.openqa.selenium.devtools.v94.backgroundservice.model.BackgroundServiceEvent;
import org.openqa.selenium.devtools.v94.backgroundservice.model.RecordingStateChanged;
import org.openqa.selenium.devtools.v94.backgroundservice.model.ServiceName;

@Beta
public class BackgroundService {
    public static Command<Void> startObserving(ServiceName service) {
        Objects.requireNonNull(service, "service is required");
        ImmutableMap.Builder params = ImmutableMap.builder();
        params.put((Object)"service", (Object)service);
        return new Command("BackgroundService.startObserving", (Map)params.build());
    }

    public static Command<Void> stopObserving(ServiceName service) {
        Objects.requireNonNull(service, "service is required");
        ImmutableMap.Builder params = ImmutableMap.builder();
        params.put((Object)"service", (Object)service);
        return new Command("BackgroundService.stopObserving", (Map)params.build());
    }

    public static Command<Void> setRecording(Boolean shouldRecord, ServiceName service) {
        Objects.requireNonNull(shouldRecord, "shouldRecord is required");
        Objects.requireNonNull(service, "service is required");
        ImmutableMap.Builder params = ImmutableMap.builder();
        params.put((Object)"shouldRecord", (Object)shouldRecord);
        params.put((Object)"service", (Object)service);
        return new Command("BackgroundService.setRecording", (Map)params.build());
    }

    public static Command<Void> clearEvents(ServiceName service) {
        Objects.requireNonNull(service, "service is required");
        ImmutableMap.Builder params = ImmutableMap.builder();
        params.put((Object)"service", (Object)service);
        return new Command("BackgroundService.clearEvents", (Map)params.build());
    }

    public static Event<RecordingStateChanged> recordingStateChanged() {
        return new Event("BackgroundService.recordingStateChanged", input -> (RecordingStateChanged)input.read(RecordingStateChanged.class));
    }

    public static Event<BackgroundServiceEvent> backgroundServiceEventReceived() {
        return new Event("BackgroundService.backgroundServiceEventReceived", ConverterFunctions.map((String)"backgroundServiceEvent", BackgroundServiceEvent.class));
    }
}

