/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.devtools.v93.page.model;

import java.util.Objects;
import java.util.Optional;
import org.openqa.selenium.Beta;
import org.openqa.selenium.json.JsonInput;

@Beta
public class CompilationCacheParams {
    private final String url;
    private final Optional<Boolean> eager;

    public CompilationCacheParams(String url, Optional<Boolean> eager) {
        this.url = Objects.requireNonNull(url, "url is required");
        this.eager = eager;
    }

    public String getUrl() {
        return this.url;
    }

    public Optional<Boolean> getEager() {
        return this.eager;
    }

    private static CompilationCacheParams fromJson(JsonInput input) {
        String url = null;
        Optional<Boolean> eager = Optional.empty();
        input.beginObject();
        block8: while (input.hasNext()) {
            switch (input.nextName()) {
                case "url": {
                    url = input.nextString();
                    continue block8;
                }
                case "eager": {
                    eager = Optional.ofNullable(input.nextBoolean());
                    continue block8;
                }
            }
            input.skipValue();
        }
        input.endObject();
        return new CompilationCacheParams(url, eager);
    }
}

