/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.devtools.v93.emulation.model;

import java.util.Arrays;
import java.util.Objects;
import org.openqa.selenium.devtools.DevToolsException;
import org.openqa.selenium.json.JsonInput;

public class DisplayFeature {
    private final Orientation orientation;
    private final Integer offset;
    private final Integer maskLength;

    public DisplayFeature(Orientation orientation, Integer offset, Integer maskLength) {
        this.orientation = Objects.requireNonNull(orientation, "orientation is required");
        this.offset = Objects.requireNonNull(offset, "offset is required");
        this.maskLength = Objects.requireNonNull(maskLength, "maskLength is required");
    }

    public Orientation getOrientation() {
        return this.orientation;
    }

    public Integer getOffset() {
        return this.offset;
    }

    public Integer getMaskLength() {
        return this.maskLength;
    }

    private static DisplayFeature fromJson(JsonInput input) {
        Orientation orientation = null;
        Integer offset = 0;
        Integer maskLength = 0;
        input.beginObject();
        block10: while (input.hasNext()) {
            switch (input.nextName()) {
                case "orientation": {
                    orientation = Orientation.fromString(input.nextString());
                    continue block10;
                }
                case "offset": {
                    offset = input.nextNumber().intValue();
                    continue block10;
                }
                case "maskLength": {
                    maskLength = input.nextNumber().intValue();
                    continue block10;
                }
            }
            input.skipValue();
        }
        input.endObject();
        return new DisplayFeature(orientation, offset, maskLength);
    }

    public static enum Orientation {
        VERTICAL("vertical"),
        HORIZONTAL("horizontal");

        private String value;

        private Orientation(String value) {
            this.value = value;
        }

        public static Orientation fromString(String s) {
            return Arrays.stream(Orientation.values()).filter(rs -> rs.value.equalsIgnoreCase(s)).findFirst().orElseThrow(() -> new DevToolsException("Given value " + s + " is not found within Orientation "));
        }

        public String toString() {
            return this.value;
        }

        public String toJson() {
            return this.value;
        }

        private static Orientation fromJson(JsonInput input) {
            return Orientation.fromString(input.nextString());
        }
    }
}

