package org.openqa.selenium.devtools.v93.page.model;

import org.openqa.selenium.Beta;
import org.openqa.selenium.json.JsonInput;

@org.openqa.selenium.Beta()
public class OriginTrialTokenWithStatus {

    private final java.lang.String rawTokenText;

    private final java.util.Optional<org.openqa.selenium.devtools.v93.page.model.OriginTrialToken> parsedToken;

    private final org.openqa.selenium.devtools.v93.page.model.OriginTrialTokenStatus status;

    public OriginTrialTokenWithStatus(java.lang.String rawTokenText, java.util.Optional<org.openqa.selenium.devtools.v93.page.model.OriginTrialToken> parsedToken, org.openqa.selenium.devtools.v93.page.model.OriginTrialTokenStatus status) {
        this.rawTokenText = java.util.Objects.requireNonNull(rawTokenText, "rawTokenText is required");
        this.parsedToken = parsedToken;
        this.status = java.util.Objects.requireNonNull(status, "status is required");
    }

    public java.lang.String getRawTokenText() {
        return rawTokenText;
    }

    /**
     * `parsedToken` is present only when the token is extractable and
     * parsable.
     */
    public java.util.Optional<org.openqa.selenium.devtools.v93.page.model.OriginTrialToken> getParsedToken() {
        return parsedToken;
    }

    public org.openqa.selenium.devtools.v93.page.model.OriginTrialTokenStatus getStatus() {
        return status;
    }

    private static OriginTrialTokenWithStatus fromJson(JsonInput input) {
        java.lang.String rawTokenText = null;
        java.util.Optional<org.openqa.selenium.devtools.v93.page.model.OriginTrialToken> parsedToken = java.util.Optional.empty();
        org.openqa.selenium.devtools.v93.page.model.OriginTrialTokenStatus status = null;
        input.beginObject();
        while (input.hasNext()) {
            switch(input.nextName()) {
                case "rawTokenText":
                    rawTokenText = input.nextString();
                    break;
                case "parsedToken":
                    parsedToken = java.util.Optional.ofNullable(input.read(org.openqa.selenium.devtools.v93.page.model.OriginTrialToken.class));
                    break;
                case "status":
                    status = input.read(org.openqa.selenium.devtools.v93.page.model.OriginTrialTokenStatus.class);
                    break;
                default:
                    input.skipValue();
                    break;
            }
        }
        input.endObject();
        return new OriginTrialTokenWithStatus(rawTokenText, parsedToken, status);
    }
}
