package org.openqa.selenium.devtools.v93.network.model;

import org.openqa.selenium.Beta;
import org.openqa.selenium.json.JsonInput;

/**
 * A cookie with was not sent with a request with the corresponding reason.
 */
@org.openqa.selenium.Beta()
public class BlockedCookieWithReason {

    private final java.util.List<org.openqa.selenium.devtools.v93.network.model.CookieBlockedReason> blockedReasons;

    private final org.openqa.selenium.devtools.v93.network.model.Cookie cookie;

    public BlockedCookieWithReason(java.util.List<org.openqa.selenium.devtools.v93.network.model.CookieBlockedReason> blockedReasons, org.openqa.selenium.devtools.v93.network.model.Cookie cookie) {
        this.blockedReasons = java.util.Objects.requireNonNull(blockedReasons, "blockedReasons is required");
        this.cookie = java.util.Objects.requireNonNull(cookie, "cookie is required");
    }

    /**
     * The reason(s) the cookie was blocked.
     */
    public java.util.List<org.openqa.selenium.devtools.v93.network.model.CookieBlockedReason> getBlockedReasons() {
        return blockedReasons;
    }

    /**
     * The cookie object representing the cookie which was not sent.
     */
    public org.openqa.selenium.devtools.v93.network.model.Cookie getCookie() {
        return cookie;
    }

    private static BlockedCookieWithReason fromJson(JsonInput input) {
        java.util.List<org.openqa.selenium.devtools.v93.network.model.CookieBlockedReason> blockedReasons = null;
        org.openqa.selenium.devtools.v93.network.model.Cookie cookie = null;
        input.beginObject();
        while (input.hasNext()) {
            switch(input.nextName()) {
                case "blockedReasons":
                    blockedReasons = input.read(new com.google.common.reflect.TypeToken<java.util.List<org.openqa.selenium.devtools.v93.network.model.CookieBlockedReason>>() {
                    }.getType());
                    break;
                case "cookie":
                    cookie = input.read(org.openqa.selenium.devtools.v93.network.model.Cookie.class);
                    break;
                default:
                    input.skipValue();
                    break;
            }
        }
        input.endObject();
        return new BlockedCookieWithReason(blockedReasons, cookie);
    }
}
