package org.openqa.selenium.devtools.v90.webauthn.model;

import org.openqa.selenium.Beta;
import org.openqa.selenium.json.JsonInput;

public enum Ctap2Version {

    CTAP2_0("ctap2_0"), CTAP2_1("ctap2_1");

    private String value;

    Ctap2Version(String value) {
        this.value = value;
    }

    public static Ctap2Version fromString(String s) {
        return java.util.Arrays.stream(Ctap2Version.values()).filter(rs -> rs.value.equalsIgnoreCase(s)).findFirst().orElseThrow(() -> new org.openqa.selenium.devtools.DevToolsException("Given value " + s + " is not found within Ctap2Version "));
    }

    public String toString() {
        return value;
    }

    public String toJson() {
        return value;
    }

    private static Ctap2Version fromJson(JsonInput input) {
        return fromString(input.nextString());
    }
}
