package org.openqa.selenium.devtools.v88.network.model;

import org.openqa.selenium.Beta;
import org.openqa.selenium.json.JsonInput;

/**
 * Source of serviceworker response.
 */
public enum ServiceWorkerResponseSource {

    CACHE_STORAGE("cache-storage"), HTTP_CACHE("http-cache"), FALLBACK_CODE("fallback-code"), NETWORK("network");

    private String value;

    ServiceWorkerResponseSource(String value) {
        this.value = value;
    }

    public static ServiceWorkerResponseSource fromString(String s) {
        return java.util.Arrays.stream(ServiceWorkerResponseSource.values()).filter(rs -> rs.value.equalsIgnoreCase(s)).findFirst().orElseThrow(() -> new org.openqa.selenium.devtools.DevToolsException("Given value " + s + " is not found within ServiceWorkerResponseSource "));
    }

    public String toString() {
        return value;
    }

    public String toJson() {
        return value;
    }

    private static ServiceWorkerResponseSource fromJson(JsonInput input) {
        return fromString(input.nextString());
    }
}
