package org.openqa.selenium.devtools.v88.audits.model;

import org.openqa.selenium.Beta;
import org.openqa.selenium.json.JsonInput;

public class HeavyAdIssueDetails {

    private final org.openqa.selenium.devtools.v88.audits.model.HeavyAdResolutionStatus resolution;

    private final org.openqa.selenium.devtools.v88.audits.model.HeavyAdReason reason;

    private final org.openqa.selenium.devtools.v88.audits.model.AffectedFrame frame;

    public HeavyAdIssueDetails(org.openqa.selenium.devtools.v88.audits.model.HeavyAdResolutionStatus resolution, org.openqa.selenium.devtools.v88.audits.model.HeavyAdReason reason, org.openqa.selenium.devtools.v88.audits.model.AffectedFrame frame) {
        this.resolution = java.util.Objects.requireNonNull(resolution, "resolution is required");
        this.reason = java.util.Objects.requireNonNull(reason, "reason is required");
        this.frame = java.util.Objects.requireNonNull(frame, "frame is required");
    }

    /**
     * The resolution status, either blocking the content or warning.
     */
    public org.openqa.selenium.devtools.v88.audits.model.HeavyAdResolutionStatus getResolution() {
        return resolution;
    }

    /**
     * The reason the ad was blocked, total network or cpu or peak cpu.
     */
    public org.openqa.selenium.devtools.v88.audits.model.HeavyAdReason getReason() {
        return reason;
    }

    /**
     * The frame that was blocked.
     */
    public org.openqa.selenium.devtools.v88.audits.model.AffectedFrame getFrame() {
        return frame;
    }

    private static HeavyAdIssueDetails fromJson(JsonInput input) {
        org.openqa.selenium.devtools.v88.audits.model.HeavyAdResolutionStatus resolution = null;
        org.openqa.selenium.devtools.v88.audits.model.HeavyAdReason reason = null;
        org.openqa.selenium.devtools.v88.audits.model.AffectedFrame frame = null;
        input.beginObject();
        while (input.hasNext()) {
            switch(input.nextName()) {
                case "resolution":
                    resolution = input.read(org.openqa.selenium.devtools.v88.audits.model.HeavyAdResolutionStatus.class);
                    break;
                case "reason":
                    reason = input.read(org.openqa.selenium.devtools.v88.audits.model.HeavyAdReason.class);
                    break;
                case "frame":
                    frame = input.read(org.openqa.selenium.devtools.v88.audits.model.AffectedFrame.class);
                    break;
                default:
                    input.skipValue();
                    break;
            }
        }
        input.endObject();
        return new HeavyAdIssueDetails(resolution, reason, frame);
    }
}
