/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.devtools.v87.audits.model;

import java.util.Objects;
import java.util.Optional;
import org.openqa.selenium.devtools.v87.audits.model.AffectedFrame;
import org.openqa.selenium.devtools.v87.audits.model.ContentSecurityPolicyViolationType;
import org.openqa.selenium.devtools.v87.audits.model.SourceCodeLocation;
import org.openqa.selenium.devtools.v87.dom.model.BackendNodeId;
import org.openqa.selenium.json.JsonInput;

public class ContentSecurityPolicyIssueDetails {
    private final Optional<String> blockedURL;
    private final String violatedDirective;
    private final ContentSecurityPolicyViolationType contentSecurityPolicyViolationType;
    private final Optional<AffectedFrame> frameAncestor;
    private final Optional<SourceCodeLocation> sourceCodeLocation;
    private final Optional<BackendNodeId> violatingNodeId;

    public ContentSecurityPolicyIssueDetails(Optional<String> blockedURL, String violatedDirective, ContentSecurityPolicyViolationType contentSecurityPolicyViolationType, Optional<AffectedFrame> frameAncestor, Optional<SourceCodeLocation> sourceCodeLocation, Optional<BackendNodeId> violatingNodeId) {
        this.blockedURL = blockedURL;
        this.violatedDirective = Objects.requireNonNull(violatedDirective, "violatedDirective is required");
        this.contentSecurityPolicyViolationType = Objects.requireNonNull(contentSecurityPolicyViolationType, "contentSecurityPolicyViolationType is required");
        this.frameAncestor = frameAncestor;
        this.sourceCodeLocation = sourceCodeLocation;
        this.violatingNodeId = violatingNodeId;
    }

    public Optional<String> getBlockedURL() {
        return this.blockedURL;
    }

    public String getViolatedDirective() {
        return this.violatedDirective;
    }

    public ContentSecurityPolicyViolationType getContentSecurityPolicyViolationType() {
        return this.contentSecurityPolicyViolationType;
    }

    public Optional<AffectedFrame> getFrameAncestor() {
        return this.frameAncestor;
    }

    public Optional<SourceCodeLocation> getSourceCodeLocation() {
        return this.sourceCodeLocation;
    }

    public Optional<BackendNodeId> getViolatingNodeId() {
        return this.violatingNodeId;
    }

    private static ContentSecurityPolicyIssueDetails fromJson(JsonInput input) {
        Optional<String> blockedURL = Optional.empty();
        String violatedDirective = null;
        ContentSecurityPolicyViolationType contentSecurityPolicyViolationType = null;
        Optional<AffectedFrame> frameAncestor = Optional.empty();
        Optional<SourceCodeLocation> sourceCodeLocation = Optional.empty();
        Optional<BackendNodeId> violatingNodeId = Optional.empty();
        input.beginObject();
        block16: while (input.hasNext()) {
            switch (input.nextName()) {
                case "blockedURL": {
                    blockedURL = Optional.ofNullable(input.nextString());
                    continue block16;
                }
                case "violatedDirective": {
                    violatedDirective = input.nextString();
                    continue block16;
                }
                case "contentSecurityPolicyViolationType": {
                    contentSecurityPolicyViolationType = (ContentSecurityPolicyViolationType)((Object)input.read(ContentSecurityPolicyViolationType.class));
                    continue block16;
                }
                case "frameAncestor": {
                    frameAncestor = Optional.ofNullable((AffectedFrame)input.read(AffectedFrame.class));
                    continue block16;
                }
                case "sourceCodeLocation": {
                    sourceCodeLocation = Optional.ofNullable((SourceCodeLocation)input.read(SourceCodeLocation.class));
                    continue block16;
                }
                case "violatingNodeId": {
                    violatingNodeId = Optional.ofNullable((BackendNodeId)input.read(BackendNodeId.class));
                    continue block16;
                }
            }
            input.skipValue();
        }
        input.endObject();
        return new ContentSecurityPolicyIssueDetails(blockedURL, violatedDirective, contentSecurityPolicyViolationType, frameAncestor, sourceCodeLocation, violatingNodeId);
    }
}

