package org.openqa.selenium.devtools.v87.profiler.model;

import org.openqa.selenium.Beta;
import org.openqa.selenium.json.JsonInput;

/**
 * Profile node. Holds callsite information, execution statistics and child nodes.
 */
public class ProfileNode {

    private final java.lang.Integer id;

    private final org.openqa.selenium.devtools.v87.runtime.model.CallFrame callFrame;

    private final java.util.Optional<java.lang.Integer> hitCount;

    private final java.util.Optional<java.util.List<java.lang.Integer>> children;

    private final java.util.Optional<java.lang.String> deoptReason;

    private final java.util.Optional<java.util.List<org.openqa.selenium.devtools.v87.profiler.model.PositionTickInfo>> positionTicks;

    public ProfileNode(java.lang.Integer id, org.openqa.selenium.devtools.v87.runtime.model.CallFrame callFrame, java.util.Optional<java.lang.Integer> hitCount, java.util.Optional<java.util.List<java.lang.Integer>> children, java.util.Optional<java.lang.String> deoptReason, java.util.Optional<java.util.List<org.openqa.selenium.devtools.v87.profiler.model.PositionTickInfo>> positionTicks) {
        this.id = java.util.Objects.requireNonNull(id, "id is required");
        this.callFrame = java.util.Objects.requireNonNull(callFrame, "callFrame is required");
        this.hitCount = hitCount;
        this.children = children;
        this.deoptReason = deoptReason;
        this.positionTicks = positionTicks;
    }

    /**
     * Unique id of the node.
     */
    public java.lang.Integer getId() {
        return id;
    }

    /**
     * Function location.
     */
    public org.openqa.selenium.devtools.v87.runtime.model.CallFrame getCallFrame() {
        return callFrame;
    }

    /**
     * Number of samples where this node was on top of the call stack.
     */
    public java.util.Optional<java.lang.Integer> getHitCount() {
        return hitCount;
    }

    /**
     * Child node ids.
     */
    public java.util.Optional<java.util.List<java.lang.Integer>> getChildren() {
        return children;
    }

    /**
     * The reason of being not optimized. The function may be deoptimized or marked as don't
     * optimize.
     */
    public java.util.Optional<java.lang.String> getDeoptReason() {
        return deoptReason;
    }

    /**
     * An array of source position ticks.
     */
    public java.util.Optional<java.util.List<org.openqa.selenium.devtools.v87.profiler.model.PositionTickInfo>> getPositionTicks() {
        return positionTicks;
    }

    private static ProfileNode fromJson(JsonInput input) {
        java.lang.Integer id = 0;
        org.openqa.selenium.devtools.v87.runtime.model.CallFrame callFrame = null;
        java.util.Optional<java.lang.Integer> hitCount = java.util.Optional.empty();
        java.util.Optional<java.util.List<java.lang.Integer>> children = java.util.Optional.empty();
        java.util.Optional<java.lang.String> deoptReason = java.util.Optional.empty();
        java.util.Optional<java.util.List<org.openqa.selenium.devtools.v87.profiler.model.PositionTickInfo>> positionTicks = java.util.Optional.empty();
        input.beginObject();
        while (input.hasNext()) {
            switch(input.nextName()) {
                case "id":
                    id = input.nextNumber().intValue();
                    break;
                case "callFrame":
                    callFrame = input.read(org.openqa.selenium.devtools.v87.runtime.model.CallFrame.class);
                    break;
                case "hitCount":
                    hitCount = java.util.Optional.ofNullable(input.nextNumber().intValue());
                    break;
                case "children":
                    children = java.util.Optional.ofNullable(input.read(new com.google.common.reflect.TypeToken<java.util.List<java.lang.Integer>>() {
                    }.getType()));
                    break;
                case "deoptReason":
                    deoptReason = java.util.Optional.ofNullable(input.nextString());
                    break;
                case "positionTicks":
                    positionTicks = java.util.Optional.ofNullable(input.read(new com.google.common.reflect.TypeToken<java.util.List<org.openqa.selenium.devtools.v87.profiler.model.PositionTickInfo>>() {
                    }.getType()));
                    break;
                default:
                    input.skipValue();
                    break;
            }
        }
        input.endObject();
        return new ProfileNode(id, callFrame, hitCount, children, deoptReason, positionTicks);
    }
}
