package org.openqa.selenium.devtools.v87.network.model;

import org.openqa.selenium.Beta;
import org.openqa.selenium.json.JsonInput;

@org.openqa.selenium.Beta()
public class SecurityIsolationStatus {

    private final org.openqa.selenium.devtools.v87.network.model.CrossOriginOpenerPolicyStatus coop;

    private final org.openqa.selenium.devtools.v87.network.model.CrossOriginEmbedderPolicyStatus coep;

    public SecurityIsolationStatus(org.openqa.selenium.devtools.v87.network.model.CrossOriginOpenerPolicyStatus coop, org.openqa.selenium.devtools.v87.network.model.CrossOriginEmbedderPolicyStatus coep) {
        this.coop = java.util.Objects.requireNonNull(coop, "coop is required");
        this.coep = java.util.Objects.requireNonNull(coep, "coep is required");
    }

    public org.openqa.selenium.devtools.v87.network.model.CrossOriginOpenerPolicyStatus getCoop() {
        return coop;
    }

    public org.openqa.selenium.devtools.v87.network.model.CrossOriginEmbedderPolicyStatus getCoep() {
        return coep;
    }

    private static SecurityIsolationStatus fromJson(JsonInput input) {
        org.openqa.selenium.devtools.v87.network.model.CrossOriginOpenerPolicyStatus coop = null;
        org.openqa.selenium.devtools.v87.network.model.CrossOriginEmbedderPolicyStatus coep = null;
        input.beginObject();
        while (input.hasNext()) {
            switch(input.nextName()) {
                case "coop":
                    coop = input.read(org.openqa.selenium.devtools.v87.network.model.CrossOriginOpenerPolicyStatus.class);
                    break;
                case "coep":
                    coep = input.read(org.openqa.selenium.devtools.v87.network.model.CrossOriginEmbedderPolicyStatus.class);
                    break;
                default:
                    input.skipValue();
                    break;
            }
        }
        input.endObject();
        return new SecurityIsolationStatus(coop, coep);
    }
}
