package org.openqa.selenium.devtools.v87.audits.model;

import org.openqa.selenium.Beta;
import org.openqa.selenium.json.JsonInput;

public enum MixedContentResourceType {

    AUDIO("Audio"),
    BEACON("Beacon"),
    CSPREPORT("CSPReport"),
    DOWNLOAD("Download"),
    EVENTSOURCE("EventSource"),
    FAVICON("Favicon"),
    FONT("Font"),
    FORM("Form"),
    FRAME("Frame"),
    IMAGE("Image"),
    IMPORT("Import"),
    MANIFEST("Manifest"),
    PING("Ping"),
    PLUGINDATA("PluginData"),
    PLUGINRESOURCE("PluginResource"),
    PREFETCH("Prefetch"),
    RESOURCE("Resource"),
    SCRIPT("Script"),
    SERVICEWORKER("ServiceWorker"),
    SHAREDWORKER("SharedWorker"),
    STYLESHEET("Stylesheet"),
    TRACK("Track"),
    VIDEO("Video"),
    WORKER("Worker"),
    XMLHTTPREQUEST("XMLHttpRequest"),
    XSLT("XSLT");

    private String value;

    MixedContentResourceType(String value) {
        this.value = value;
    }

    public static MixedContentResourceType fromString(String s) {
        return java.util.Arrays.stream(MixedContentResourceType.values()).filter(rs -> rs.value.equalsIgnoreCase(s)).findFirst().orElseThrow(() -> new org.openqa.selenium.devtools.DevToolsException("Given value " + s + " is not found within MixedContentResourceType "));
    }

    public String toString() {
        return value;
    }

    public String toJson() {
        return value;
    }

    private static MixedContentResourceType fromJson(JsonInput input) {
        return fromString(input.nextString());
    }
}
