/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.devtools.v85.serviceworker;

import com.google.common.collect.ImmutableMap;
import com.google.common.reflect.TypeToken;
import java.lang.reflect.Type;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.openqa.selenium.Beta;
import org.openqa.selenium.devtools.Command;
import org.openqa.selenium.devtools.ConverterFunctions;
import org.openqa.selenium.devtools.Event;
import org.openqa.selenium.devtools.v85.serviceworker.model.RegistrationID;
import org.openqa.selenium.devtools.v85.serviceworker.model.ServiceWorkerErrorMessage;
import org.openqa.selenium.devtools.v85.serviceworker.model.ServiceWorkerRegistration;
import org.openqa.selenium.devtools.v85.serviceworker.model.ServiceWorkerVersion;

@Beta
public class ServiceWorker {
    public static Command<Void> deliverPushMessage(String origin, RegistrationID registrationId, String data) {
        Objects.requireNonNull(origin, "origin is required");
        Objects.requireNonNull(registrationId, "registrationId is required");
        Objects.requireNonNull(data, "data is required");
        ImmutableMap.Builder params = ImmutableMap.builder();
        params.put((Object)"origin", (Object)origin);
        params.put((Object)"registrationId", (Object)registrationId);
        params.put((Object)"data", (Object)data);
        return new Command("ServiceWorker.deliverPushMessage", (Map)params.build());
    }

    public static Command<Void> disable() {
        ImmutableMap.Builder params = ImmutableMap.builder();
        return new Command("ServiceWorker.disable", (Map)params.build());
    }

    public static Command<Void> dispatchSyncEvent(String origin, RegistrationID registrationId, String tag, Boolean lastChance) {
        Objects.requireNonNull(origin, "origin is required");
        Objects.requireNonNull(registrationId, "registrationId is required");
        Objects.requireNonNull(tag, "tag is required");
        Objects.requireNonNull(lastChance, "lastChance is required");
        ImmutableMap.Builder params = ImmutableMap.builder();
        params.put((Object)"origin", (Object)origin);
        params.put((Object)"registrationId", (Object)registrationId);
        params.put((Object)"tag", (Object)tag);
        params.put((Object)"lastChance", (Object)lastChance);
        return new Command("ServiceWorker.dispatchSyncEvent", (Map)params.build());
    }

    public static Command<Void> dispatchPeriodicSyncEvent(String origin, RegistrationID registrationId, String tag) {
        Objects.requireNonNull(origin, "origin is required");
        Objects.requireNonNull(registrationId, "registrationId is required");
        Objects.requireNonNull(tag, "tag is required");
        ImmutableMap.Builder params = ImmutableMap.builder();
        params.put((Object)"origin", (Object)origin);
        params.put((Object)"registrationId", (Object)registrationId);
        params.put((Object)"tag", (Object)tag);
        return new Command("ServiceWorker.dispatchPeriodicSyncEvent", (Map)params.build());
    }

    public static Command<Void> enable() {
        ImmutableMap.Builder params = ImmutableMap.builder();
        return new Command("ServiceWorker.enable", (Map)params.build());
    }

    public static Command<Void> inspectWorker(String versionId) {
        Objects.requireNonNull(versionId, "versionId is required");
        ImmutableMap.Builder params = ImmutableMap.builder();
        params.put((Object)"versionId", (Object)versionId);
        return new Command("ServiceWorker.inspectWorker", (Map)params.build());
    }

    public static Command<Void> setForceUpdateOnPageLoad(Boolean forceUpdateOnPageLoad) {
        Objects.requireNonNull(forceUpdateOnPageLoad, "forceUpdateOnPageLoad is required");
        ImmutableMap.Builder params = ImmutableMap.builder();
        params.put((Object)"forceUpdateOnPageLoad", (Object)forceUpdateOnPageLoad);
        return new Command("ServiceWorker.setForceUpdateOnPageLoad", (Map)params.build());
    }

    public static Command<Void> skipWaiting(String scopeURL) {
        Objects.requireNonNull(scopeURL, "scopeURL is required");
        ImmutableMap.Builder params = ImmutableMap.builder();
        params.put((Object)"scopeURL", (Object)scopeURL);
        return new Command("ServiceWorker.skipWaiting", (Map)params.build());
    }

    public static Command<Void> startWorker(String scopeURL) {
        Objects.requireNonNull(scopeURL, "scopeURL is required");
        ImmutableMap.Builder params = ImmutableMap.builder();
        params.put((Object)"scopeURL", (Object)scopeURL);
        return new Command("ServiceWorker.startWorker", (Map)params.build());
    }

    public static Command<Void> stopAllWorkers() {
        ImmutableMap.Builder params = ImmutableMap.builder();
        return new Command("ServiceWorker.stopAllWorkers", (Map)params.build());
    }

    public static Command<Void> stopWorker(String versionId) {
        Objects.requireNonNull(versionId, "versionId is required");
        ImmutableMap.Builder params = ImmutableMap.builder();
        params.put((Object)"versionId", (Object)versionId);
        return new Command("ServiceWorker.stopWorker", (Map)params.build());
    }

    public static Command<Void> unregister(String scopeURL) {
        Objects.requireNonNull(scopeURL, "scopeURL is required");
        ImmutableMap.Builder params = ImmutableMap.builder();
        params.put((Object)"scopeURL", (Object)scopeURL);
        return new Command("ServiceWorker.unregister", (Map)params.build());
    }

    public static Command<Void> updateRegistration(String scopeURL) {
        Objects.requireNonNull(scopeURL, "scopeURL is required");
        ImmutableMap.Builder params = ImmutableMap.builder();
        params.put((Object)"scopeURL", (Object)scopeURL);
        return new Command("ServiceWorker.updateRegistration", (Map)params.build());
    }

    public static Event<ServiceWorkerErrorMessage> workerErrorReported() {
        return new Event("ServiceWorker.workerErrorReported", ConverterFunctions.map((String)"errorMessage", ServiceWorkerErrorMessage.class));
    }

    public static Event<List<ServiceWorkerRegistration>> workerRegistrationUpdated() {
        return new Event("ServiceWorker.workerRegistrationUpdated", ConverterFunctions.map((String)"registrations", (Type)new TypeToken<List<ServiceWorkerRegistration>>(){}.getType()));
    }

    public static Event<List<ServiceWorkerVersion>> workerVersionUpdated() {
        return new Event("ServiceWorker.workerVersionUpdated", ConverterFunctions.map((String)"versions", (Type)new TypeToken<List<ServiceWorkerVersion>>(){}.getType()));
    }
}

