/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.devtools.v85;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;
import org.openqa.selenium.UsernameAndPassword;
import org.openqa.selenium.devtools.Command;
import org.openqa.selenium.devtools.DevTools;
import org.openqa.selenium.devtools.Event;
import org.openqa.selenium.devtools.v85.fetch.Fetch;
import org.openqa.selenium.devtools.v85.fetch.model.AuthChallengeResponse;
import org.openqa.selenium.devtools.v85.fetch.model.AuthRequired;
import org.openqa.selenium.devtools.v85.fetch.model.HeaderEntry;
import org.openqa.selenium.devtools.v85.fetch.model.RequestPattern;
import org.openqa.selenium.devtools.v85.fetch.model.RequestPaused;
import org.openqa.selenium.devtools.v85.network.Network;
import org.openqa.selenium.devtools.v85.network.model.Request;
import org.openqa.selenium.remote.http.Contents;
import org.openqa.selenium.remote.http.HttpRequest;
import org.openqa.selenium.remote.http.HttpResponse;

public class V85Network
extends org.openqa.selenium.devtools.idealized.Network<AuthRequired, RequestPaused> {
    public V85Network(DevTools devTools) {
        super(devTools);
    }

    protected Command<Void> enableNetworkCaching() {
        return Network.setCacheDisabled(false);
    }

    protected Command<Void> disableNetworkCaching() {
        return Network.setCacheDisabled(true);
    }

    protected Command<Void> enableFetchForAllPatterns() {
        return Fetch.enable(Optional.of(ImmutableList.of((Object)new RequestPattern(Optional.of("*"), Optional.empty(), Optional.empty()))), Optional.of(true));
    }

    protected Command<Void> disableFetch() {
        return Fetch.disable();
    }

    protected Event<AuthRequired> authRequiredEvent() {
        return Fetch.authRequired();
    }

    protected String getUriFrom(AuthRequired authRequired) {
        return authRequired.getAuthChallenge().getOrigin();
    }

    protected Command<Void> continueWithAuth(AuthRequired authRequired, UsernameAndPassword credentials) {
        return Fetch.continueWithAuth(authRequired.getRequestId(), new AuthChallengeResponse(AuthChallengeResponse.Response.PROVIDECREDENTIALS, Optional.of(credentials.username()), Optional.ofNullable(credentials.username())));
    }

    protected Command<Void> cancelAuth(AuthRequired authRequired) {
        return Fetch.continueWithAuth(authRequired.getRequestId(), new AuthChallengeResponse(AuthChallengeResponse.Response.CANCELAUTH, Optional.empty(), Optional.empty()));
    }

    protected Event<RequestPaused> requestPausedEvent() {
        return Fetch.requestPaused();
    }

    protected Optional<HttpRequest> createHttpRequest(RequestPaused pausedRequest) {
        if (pausedRequest.getResponseErrorReason().isPresent() || pausedRequest.getResponseStatusCode().isPresent()) {
            return Optional.empty();
        }
        Request cdpRequest = pausedRequest.getRequest();
        return Optional.of(this.createHttpRequest(cdpRequest.getMethod(), cdpRequest.getUrl(), (Map)((Object)cdpRequest.getHeaders()), cdpRequest.getPostData()));
    }

    protected Command<Void> continueWithoutModification(RequestPaused pausedRequest) {
        return Fetch.continueRequest(pausedRequest.getRequestId(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty());
    }

    protected Command<Void> createResponse(RequestPaused pausedRequest, HttpResponse response) {
        ArrayList headers = new ArrayList();
        response.getHeaderNames().forEach(name -> response.getHeaders(name).forEach(value -> headers.add(new HeaderEntry((String)name, (String)value))));
        byte[] bytes = Contents.bytes((Supplier)response.getContent());
        String body = bytes.length > 0 ? Base64.getEncoder().encodeToString(bytes) : null;
        return Fetch.fulfillRequest(pausedRequest.getRequestId(), response.getStatus(), Optional.of(headers), Optional.empty(), Optional.ofNullable(body), Optional.empty());
    }
}

