/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.devtools.v84.profiler;

import com.google.common.collect.ImmutableMap;
import com.google.common.reflect.TypeToken;
import java.lang.reflect.Type;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.openqa.selenium.Beta;
import org.openqa.selenium.devtools.Command;
import org.openqa.selenium.devtools.ConverterFunctions;
import org.openqa.selenium.devtools.Event;
import org.openqa.selenium.devtools.v84.profiler.model.ConsoleProfileFinished;
import org.openqa.selenium.devtools.v84.profiler.model.ConsoleProfileStarted;
import org.openqa.selenium.devtools.v84.profiler.model.CounterInfo;
import org.openqa.selenium.devtools.v84.profiler.model.PreciseCoverageDeltaUpdate;
import org.openqa.selenium.devtools.v84.profiler.model.Profile;
import org.openqa.selenium.devtools.v84.profiler.model.ScriptCoverage;
import org.openqa.selenium.devtools.v84.profiler.model.ScriptTypeProfile;
import org.openqa.selenium.json.JsonInput;

public class Profiler {
    public static Command<Void> disable() {
        ImmutableMap.Builder params = ImmutableMap.builder();
        return new Command("Profiler.disable", (Map)params.build());
    }

    public static Command<Void> enable() {
        ImmutableMap.Builder params = ImmutableMap.builder();
        return new Command("Profiler.enable", (Map)params.build());
    }

    public static Command<List<ScriptCoverage>> getBestEffortCoverage() {
        ImmutableMap.Builder params = ImmutableMap.builder();
        return new Command("Profiler.getBestEffortCoverage", (Map)params.build(), ConverterFunctions.map((String)"result", (Type)new TypeToken<List<ScriptCoverage>>(){}.getType()));
    }

    public static Command<Void> setSamplingInterval(Integer interval) {
        Objects.requireNonNull(interval, "interval is required");
        ImmutableMap.Builder params = ImmutableMap.builder();
        params.put((Object)"interval", (Object)interval);
        return new Command("Profiler.setSamplingInterval", (Map)params.build());
    }

    public static Command<Void> start() {
        ImmutableMap.Builder params = ImmutableMap.builder();
        return new Command("Profiler.start", (Map)params.build());
    }

    public static Command<Number> startPreciseCoverage(Optional<Boolean> callCount, Optional<Boolean> detailed, Optional<Boolean> allowTriggeredUpdates) {
        ImmutableMap.Builder params = ImmutableMap.builder();
        callCount.ifPresent(p -> params.put((Object)"callCount", p));
        detailed.ifPresent(p -> params.put((Object)"detailed", p));
        allowTriggeredUpdates.ifPresent(p -> params.put((Object)"allowTriggeredUpdates", p));
        return new Command("Profiler.startPreciseCoverage", (Map)params.build(), ConverterFunctions.map((String)"timestamp", Number.class));
    }

    @Beta
    public static Command<Void> startTypeProfile() {
        ImmutableMap.Builder params = ImmutableMap.builder();
        return new Command("Profiler.startTypeProfile", (Map)params.build());
    }

    public static Command<Profile> stop() {
        ImmutableMap.Builder params = ImmutableMap.builder();
        return new Command("Profiler.stop", (Map)params.build(), ConverterFunctions.map((String)"profile", Profile.class));
    }

    public static Command<Void> stopPreciseCoverage() {
        ImmutableMap.Builder params = ImmutableMap.builder();
        return new Command("Profiler.stopPreciseCoverage", (Map)params.build());
    }

    @Beta
    public static Command<Void> stopTypeProfile() {
        ImmutableMap.Builder params = ImmutableMap.builder();
        return new Command("Profiler.stopTypeProfile", (Map)params.build());
    }

    public static Command<TakePreciseCoverageResponse> takePreciseCoverage() {
        ImmutableMap.Builder params = ImmutableMap.builder();
        return new Command("Profiler.takePreciseCoverage", (Map)params.build(), input -> (TakePreciseCoverageResponse)input.read(TakePreciseCoverageResponse.class));
    }

    @Beta
    public static Command<List<ScriptTypeProfile>> takeTypeProfile() {
        ImmutableMap.Builder params = ImmutableMap.builder();
        return new Command("Profiler.takeTypeProfile", (Map)params.build(), ConverterFunctions.map((String)"result", (Type)new TypeToken<List<ScriptTypeProfile>>(){}.getType()));
    }

    @Beta
    public static Command<Void> enableRuntimeCallStats() {
        ImmutableMap.Builder params = ImmutableMap.builder();
        return new Command("Profiler.enableRuntimeCallStats", (Map)params.build());
    }

    @Beta
    public static Command<Void> disableRuntimeCallStats() {
        ImmutableMap.Builder params = ImmutableMap.builder();
        return new Command("Profiler.disableRuntimeCallStats", (Map)params.build());
    }

    @Beta
    public static Command<List<CounterInfo>> getRuntimeCallStats() {
        ImmutableMap.Builder params = ImmutableMap.builder();
        return new Command("Profiler.getRuntimeCallStats", (Map)params.build(), ConverterFunctions.map((String)"result", (Type)new TypeToken<List<CounterInfo>>(){}.getType()));
    }

    public static Event<ConsoleProfileFinished> consoleProfileFinished() {
        return new Event("Profiler.consoleProfileFinished", input -> (ConsoleProfileFinished)input.read(ConsoleProfileFinished.class));
    }

    public static Event<ConsoleProfileStarted> consoleProfileStarted() {
        return new Event("Profiler.consoleProfileStarted", input -> (ConsoleProfileStarted)input.read(ConsoleProfileStarted.class));
    }

    public static Event<PreciseCoverageDeltaUpdate> preciseCoverageDeltaUpdate() {
        return new Event("Profiler.preciseCoverageDeltaUpdate", input -> (PreciseCoverageDeltaUpdate)input.read(PreciseCoverageDeltaUpdate.class));
    }

    public static class TakePreciseCoverageResponse {
        private final List<ScriptCoverage> result;
        private final Number timestamp;

        public TakePreciseCoverageResponse(List<ScriptCoverage> result, Number timestamp) {
            this.result = Objects.requireNonNull(result, "result is required");
            this.timestamp = Objects.requireNonNull(timestamp, "timestamp is required");
        }

        public List<ScriptCoverage> getResult() {
            return this.result;
        }

        public Number getTimestamp() {
            return this.timestamp;
        }

        private static TakePreciseCoverageResponse fromJson(JsonInput input) {
            List result = null;
            Number timestamp = 0;
            input.beginObject();
            block8: while (input.hasNext()) {
                switch (input.nextName()) {
                    case "result": {
                        result = (List)input.read(new TypeToken<List<ScriptCoverage>>(){}.getType());
                        continue block8;
                    }
                    case "timestamp": {
                        timestamp = input.nextNumber();
                        continue block8;
                    }
                }
                input.skipValue();
            }
            input.endObject();
            return new TakePreciseCoverageResponse(result, timestamp);
        }
    }
}

