/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.devtools.v84;

import java.util.logging.Level;
import org.openqa.selenium.devtools.Command;
import org.openqa.selenium.devtools.Event;
import org.openqa.selenium.devtools.v84.log.Log;
import org.openqa.selenium.devtools.v84.log.model.LogEntry;
import org.openqa.selenium.devtools.v84.runtime.model.Timestamp;

public class V84Log
implements org.openqa.selenium.devtools.idealized.log.Log {
    public Command<Void> enable() {
        return Log.enable();
    }

    public Command<Void> clear() {
        return Log.clear();
    }

    public Event<org.openqa.selenium.devtools.idealized.log.model.LogEntry> entryAdded() {
        return new Event(Log.entryAdded().getMethod(), input -> {
            LogEntry entry = (LogEntry)input.read(LogEntry.class);
            return new org.openqa.selenium.devtools.idealized.log.model.LogEntry(entry.getSource().toString(), new org.openqa.selenium.logging.LogEntry(this.fromCdpLevel(entry.getLevel()), this.fromCdpTimestamp(entry.getTimestamp()), entry.getText()));
        });
    }

    private Level fromCdpLevel(LogEntry.Level level) {
        switch (level.toString()) {
            case "verbose": {
                return Level.FINEST;
            }
            case "info": {
                return Level.INFO;
            }
            case "warning": {
                return Level.WARNING;
            }
            case "error": {
                return Level.SEVERE;
            }
        }
        return Level.INFO;
    }

    private long fromCdpTimestamp(Timestamp timestamp) {
        try {
            return Long.parseLong(timestamp.toString());
        }
        catch (NumberFormatException e) {
            return System.currentTimeMillis();
        }
    }
}

