package org.openqa.selenium.devtools.v84.profiler.model;

import org.openqa.selenium.Beta;
import org.openqa.selenium.json.JsonInput;

/**
 * Collected counter information.
 */
@org.openqa.selenium.Beta()
public class CounterInfo {

    private final java.lang.String name;

    private final java.lang.Integer value;

    public CounterInfo(java.lang.String name, java.lang.Integer value) {
        this.name = java.util.Objects.requireNonNull(name, "name is required");
        this.value = java.util.Objects.requireNonNull(value, "value is required");
    }

    /**
     * Counter name.
     */
    public java.lang.String getName() {
        return name;
    }

    /**
     * Counter value.
     */
    public java.lang.Integer getValue() {
        return value;
    }

    private static CounterInfo fromJson(JsonInput input) {
        java.lang.String name = null;
        java.lang.Integer value = 0;
        input.beginObject();
        while (input.hasNext()) {
            switch(input.nextName()) {
                case "name":
                    name = input.nextString();
                    break;
                case "value":
                    value = input.nextNumber().intValue();
                    break;
                default:
                    input.skipValue();
                    break;
            }
        }
        input.endObject();
        return new CounterInfo(name, value);
    }
}
