package org.openqa.selenium.devtools.v84.css.model;

import org.openqa.selenium.Beta;
import org.openqa.selenium.json.JsonInput;

/**
 * CSS stylesheet metainformation.
 */
public class CSSStyleSheetHeader {

    private final org.openqa.selenium.devtools.v84.css.model.StyleSheetId styleSheetId;

    private final org.openqa.selenium.devtools.v84.page.model.FrameId frameId;

    private final java.lang.String sourceURL;

    private final java.util.Optional<java.lang.String> sourceMapURL;

    private final org.openqa.selenium.devtools.v84.css.model.StyleSheetOrigin origin;

    private final java.lang.String title;

    private final java.util.Optional<org.openqa.selenium.devtools.v84.dom.model.BackendNodeId> ownerNode;

    private final java.lang.Boolean disabled;

    private final java.util.Optional<java.lang.Boolean> hasSourceURL;

    private final java.lang.Boolean isInline;

    private final java.lang.Number startLine;

    private final java.lang.Number startColumn;

    private final java.lang.Number length;

    private final java.lang.Number endLine;

    private final java.lang.Number endColumn;

    public CSSStyleSheetHeader(org.openqa.selenium.devtools.v84.css.model.StyleSheetId styleSheetId, org.openqa.selenium.devtools.v84.page.model.FrameId frameId, java.lang.String sourceURL, java.util.Optional<java.lang.String> sourceMapURL, org.openqa.selenium.devtools.v84.css.model.StyleSheetOrigin origin, java.lang.String title, java.util.Optional<org.openqa.selenium.devtools.v84.dom.model.BackendNodeId> ownerNode, java.lang.Boolean disabled, java.util.Optional<java.lang.Boolean> hasSourceURL, java.lang.Boolean isInline, java.lang.Number startLine, java.lang.Number startColumn, java.lang.Number length, java.lang.Number endLine, java.lang.Number endColumn) {
        this.styleSheetId = java.util.Objects.requireNonNull(styleSheetId, "styleSheetId is required");
        this.frameId = java.util.Objects.requireNonNull(frameId, "frameId is required");
        this.sourceURL = java.util.Objects.requireNonNull(sourceURL, "sourceURL is required");
        this.sourceMapURL = sourceMapURL;
        this.origin = java.util.Objects.requireNonNull(origin, "origin is required");
        this.title = java.util.Objects.requireNonNull(title, "title is required");
        this.ownerNode = ownerNode;
        this.disabled = java.util.Objects.requireNonNull(disabled, "disabled is required");
        this.hasSourceURL = hasSourceURL;
        this.isInline = java.util.Objects.requireNonNull(isInline, "isInline is required");
        this.startLine = java.util.Objects.requireNonNull(startLine, "startLine is required");
        this.startColumn = java.util.Objects.requireNonNull(startColumn, "startColumn is required");
        this.length = java.util.Objects.requireNonNull(length, "length is required");
        this.endLine = java.util.Objects.requireNonNull(endLine, "endLine is required");
        this.endColumn = java.util.Objects.requireNonNull(endColumn, "endColumn is required");
    }

    /**
     * The stylesheet identifier.
     */
    public org.openqa.selenium.devtools.v84.css.model.StyleSheetId getStyleSheetId() {
        return styleSheetId;
    }

    /**
     * Owner frame identifier.
     */
    public org.openqa.selenium.devtools.v84.page.model.FrameId getFrameId() {
        return frameId;
    }

    /**
     * Stylesheet resource URL.
     */
    public java.lang.String getSourceURL() {
        return sourceURL;
    }

    /**
     * URL of source map associated with the stylesheet (if any).
     */
    public java.util.Optional<java.lang.String> getSourceMapURL() {
        return sourceMapURL;
    }

    /**
     * Stylesheet origin.
     */
    public org.openqa.selenium.devtools.v84.css.model.StyleSheetOrigin getOrigin() {
        return origin;
    }

    /**
     * Stylesheet title.
     */
    public java.lang.String getTitle() {
        return title;
    }

    /**
     * The backend id for the owner node of the stylesheet.
     */
    public java.util.Optional<org.openqa.selenium.devtools.v84.dom.model.BackendNodeId> getOwnerNode() {
        return ownerNode;
    }

    /**
     * Denotes whether the stylesheet is disabled.
     */
    public java.lang.Boolean getDisabled() {
        return disabled;
    }

    /**
     * Whether the sourceURL field value comes from the sourceURL comment.
     */
    public java.util.Optional<java.lang.Boolean> getHasSourceURL() {
        return hasSourceURL;
    }

    /**
     * Whether this stylesheet is created for STYLE tag by parser. This flag is not set for
     * document.written STYLE tags.
     */
    public java.lang.Boolean getIsInline() {
        return isInline;
    }

    /**
     * Line offset of the stylesheet within the resource (zero based).
     */
    public java.lang.Number getStartLine() {
        return startLine;
    }

    /**
     * Column offset of the stylesheet within the resource (zero based).
     */
    public java.lang.Number getStartColumn() {
        return startColumn;
    }

    /**
     * Size of the content (in characters).
     */
    public java.lang.Number getLength() {
        return length;
    }

    /**
     * Line offset of the end of the stylesheet within the resource (zero based).
     */
    public java.lang.Number getEndLine() {
        return endLine;
    }

    /**
     * Column offset of the end of the stylesheet within the resource (zero based).
     */
    public java.lang.Number getEndColumn() {
        return endColumn;
    }

    private static CSSStyleSheetHeader fromJson(JsonInput input) {
        org.openqa.selenium.devtools.v84.css.model.StyleSheetId styleSheetId = null;
        org.openqa.selenium.devtools.v84.page.model.FrameId frameId = null;
        java.lang.String sourceURL = null;
        java.util.Optional<java.lang.String> sourceMapURL = java.util.Optional.empty();
        org.openqa.selenium.devtools.v84.css.model.StyleSheetOrigin origin = null;
        java.lang.String title = null;
        java.util.Optional<org.openqa.selenium.devtools.v84.dom.model.BackendNodeId> ownerNode = java.util.Optional.empty();
        java.lang.Boolean disabled = false;
        java.util.Optional<java.lang.Boolean> hasSourceURL = java.util.Optional.empty();
        java.lang.Boolean isInline = false;
        java.lang.Number startLine = 0;
        java.lang.Number startColumn = 0;
        java.lang.Number length = 0;
        java.lang.Number endLine = 0;
        java.lang.Number endColumn = 0;
        input.beginObject();
        while (input.hasNext()) {
            switch(input.nextName()) {
                case "styleSheetId":
                    styleSheetId = input.read(org.openqa.selenium.devtools.v84.css.model.StyleSheetId.class);
                    break;
                case "frameId":
                    frameId = input.read(org.openqa.selenium.devtools.v84.page.model.FrameId.class);
                    break;
                case "sourceURL":
                    sourceURL = input.nextString();
                    break;
                case "sourceMapURL":
                    sourceMapURL = java.util.Optional.ofNullable(input.nextString());
                    break;
                case "origin":
                    origin = input.read(org.openqa.selenium.devtools.v84.css.model.StyleSheetOrigin.class);
                    break;
                case "title":
                    title = input.nextString();
                    break;
                case "ownerNode":
                    ownerNode = java.util.Optional.ofNullable(input.read(org.openqa.selenium.devtools.v84.dom.model.BackendNodeId.class));
                    break;
                case "disabled":
                    disabled = input.nextBoolean();
                    break;
                case "hasSourceURL":
                    hasSourceURL = java.util.Optional.ofNullable(input.nextBoolean());
                    break;
                case "isInline":
                    isInline = input.nextBoolean();
                    break;
                case "startLine":
                    startLine = input.nextNumber();
                    break;
                case "startColumn":
                    startColumn = input.nextNumber();
                    break;
                case "length":
                    length = input.nextNumber();
                    break;
                case "endLine":
                    endLine = input.nextNumber();
                    break;
                case "endColumn":
                    endColumn = input.nextNumber();
                    break;
                default:
                    input.skipValue();
                    break;
            }
        }
        input.endObject();
        return new CSSStyleSheetHeader(styleSheetId, frameId, sourceURL, sourceMapURL, origin, title, ownerNode, disabled, hasSourceURL, isInline, startLine, startColumn, length, endLine, endColumn);
    }
}
