/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.devtools.v142.page.model;

import java.util.Objects;
import java.util.Optional;
import org.openqa.selenium.Beta;
import org.openqa.selenium.devtools.v142.page.model.OriginTrialToken;
import org.openqa.selenium.devtools.v142.page.model.OriginTrialTokenStatus;
import org.openqa.selenium.json.JsonInput;

@Beta
public class OriginTrialTokenWithStatus {
    private final String rawTokenText;
    private final Optional<OriginTrialToken> parsedToken;
    private final OriginTrialTokenStatus status;

    public OriginTrialTokenWithStatus(String rawTokenText, Optional<OriginTrialToken> parsedToken, OriginTrialTokenStatus status) {
        this.rawTokenText = Objects.requireNonNull(rawTokenText, "rawTokenText is required");
        this.parsedToken = parsedToken;
        this.status = Objects.requireNonNull(status, "status is required");
    }

    public String getRawTokenText() {
        return this.rawTokenText;
    }

    public Optional<OriginTrialToken> getParsedToken() {
        return this.parsedToken;
    }

    public OriginTrialTokenStatus getStatus() {
        return this.status;
    }

    private static OriginTrialTokenWithStatus fromJson(JsonInput input) {
        String rawTokenText = null;
        Optional<OriginTrialToken> parsedToken = Optional.empty();
        OriginTrialTokenStatus status = null;
        input.beginObject();
        block10: while (input.hasNext()) {
            switch (input.nextName()) {
                case "rawTokenText": {
                    rawTokenText = input.nextString();
                    continue block10;
                }
                case "parsedToken": {
                    parsedToken = Optional.ofNullable((OriginTrialToken)input.read(OriginTrialToken.class));
                    continue block10;
                }
                case "status": {
                    status = (OriginTrialTokenStatus)((Object)input.read(OriginTrialTokenStatus.class));
                    continue block10;
                }
            }
            input.skipValue();
        }
        input.endObject();
        return new OriginTrialTokenWithStatus(rawTokenText, parsedToken, status);
    }
}

