/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.devtools.v142.audits.model;

import java.util.Objects;
import java.util.Optional;
import org.openqa.selenium.devtools.v142.audits.model.AffectedFrame;
import org.openqa.selenium.devtools.v142.audits.model.SourceCodeLocation;
import org.openqa.selenium.json.JsonInput;

public class DeprecationIssueDetails {
    private final Optional<AffectedFrame> affectedFrame;
    private final SourceCodeLocation sourceCodeLocation;
    private final String type;

    public DeprecationIssueDetails(Optional<AffectedFrame> affectedFrame, SourceCodeLocation sourceCodeLocation, String type) {
        this.affectedFrame = affectedFrame;
        this.sourceCodeLocation = Objects.requireNonNull(sourceCodeLocation, "sourceCodeLocation is required");
        this.type = Objects.requireNonNull(type, "type is required");
    }

    public Optional<AffectedFrame> getAffectedFrame() {
        return this.affectedFrame;
    }

    public SourceCodeLocation getSourceCodeLocation() {
        return this.sourceCodeLocation;
    }

    public String getType() {
        return this.type;
    }

    private static DeprecationIssueDetails fromJson(JsonInput input) {
        Optional<AffectedFrame> affectedFrame = Optional.empty();
        SourceCodeLocation sourceCodeLocation = null;
        String type = null;
        input.beginObject();
        block10: while (input.hasNext()) {
            switch (input.nextName()) {
                case "affectedFrame": {
                    affectedFrame = Optional.ofNullable((AffectedFrame)input.read(AffectedFrame.class));
                    continue block10;
                }
                case "sourceCodeLocation": {
                    sourceCodeLocation = (SourceCodeLocation)input.read(SourceCodeLocation.class);
                    continue block10;
                }
                case "type": {
                    type = input.nextString();
                    continue block10;
                }
            }
            input.skipValue();
        }
        input.endObject();
        return new DeprecationIssueDetails(affectedFrame, sourceCodeLocation, type);
    }
}

