package org.openqa.selenium.devtools.v139.dom.model;

import org.openqa.selenium.Beta;
import org.openqa.selenium.json.JsonInput;

/**
 * ContainerSelector logical axes
 */
public enum LogicalAxes {

    INLINE("Inline"), BLOCK("Block"), BOTH("Both");

    private String value;

    LogicalAxes(String value) {
        this.value = value;
    }

    public static LogicalAxes fromString(String s) {
        return java.util.Arrays.stream(LogicalAxes.values()).filter(rs -> rs.value.equalsIgnoreCase(s)).findFirst().orElseThrow(() -> new org.openqa.selenium.devtools.DevToolsException("Given value " + s + " is not found within LogicalAxes "));
    }

    public String toString() {
        return value;
    }

    public String toJson() {
        return value;
    }

    private static LogicalAxes fromJson(JsonInput input) {
        return fromString(input.nextString());
    }
}
