package org.openqa.selenium.devtools.v139.css.model;

import org.openqa.selenium.Beta;
import org.openqa.selenium.json.JsonInput;

/**
 * Information about font variation axes for variable fonts
 */
public class FontVariationAxis {

    private final java.lang.String tag;

    private final java.lang.String name;

    private final java.lang.Number minValue;

    private final java.lang.Number maxValue;

    private final java.lang.Number defaultValue;

    public FontVariationAxis(java.lang.String tag, java.lang.String name, java.lang.Number minValue, java.lang.Number maxValue, java.lang.Number defaultValue) {
        this.tag = java.util.Objects.requireNonNull(tag, "tag is required");
        this.name = java.util.Objects.requireNonNull(name, "name is required");
        this.minValue = java.util.Objects.requireNonNull(minValue, "minValue is required");
        this.maxValue = java.util.Objects.requireNonNull(maxValue, "maxValue is required");
        this.defaultValue = java.util.Objects.requireNonNull(defaultValue, "defaultValue is required");
    }

    /**
     * The font-variation-setting tag (a.k.a. "axis tag").
     */
    public java.lang.String getTag() {
        return tag;
    }

    /**
     * Human-readable variation name in the default language (normally, "en").
     */
    public java.lang.String getName() {
        return name;
    }

    /**
     * The minimum value (inclusive) the font supports for this tag.
     */
    public java.lang.Number getMinValue() {
        return minValue;
    }

    /**
     * The maximum value (inclusive) the font supports for this tag.
     */
    public java.lang.Number getMaxValue() {
        return maxValue;
    }

    /**
     * The default value.
     */
    public java.lang.Number getDefaultValue() {
        return defaultValue;
    }

    private static FontVariationAxis fromJson(JsonInput input) {
        java.lang.String tag = null;
        java.lang.String name = null;
        java.lang.Number minValue = 0;
        java.lang.Number maxValue = 0;
        java.lang.Number defaultValue = 0;
        input.beginObject();
        while (input.hasNext()) {
            switch(input.nextName()) {
                case "tag":
                    tag = input.nextString();
                    break;
                case "name":
                    name = input.nextString();
                    break;
                case "minValue":
                    minValue = input.nextNumber();
                    break;
                case "maxValue":
                    maxValue = input.nextNumber();
                    break;
                case "defaultValue":
                    defaultValue = input.nextNumber();
                    break;
                default:
                    input.skipValue();
                    break;
            }
        }
        input.endObject();
        return new FontVariationAxis(tag, name, minValue, maxValue, defaultValue);
    }
}
