/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.devtools.v138.audits.model;

import java.util.Arrays;
import org.openqa.selenium.devtools.DevToolsException;
import org.openqa.selenium.json.JsonInput;

public enum InsightType {
    GITHUBRESOURCE("GitHubResource"),
    GRACEPERIOD("GracePeriod"),
    HEURISTICS("Heuristics");

    private String value;

    private InsightType(String value) {
        this.value = value;
    }

    public static InsightType fromString(String s) {
        return Arrays.stream(InsightType.values()).filter(rs -> rs.value.equalsIgnoreCase(s)).findFirst().orElseThrow(() -> new DevToolsException("Given value " + s + " is not found within InsightType "));
    }

    public String toString() {
        return this.value;
    }

    public String toJson() {
        return this.value;
    }

    private static InsightType fromJson(JsonInput input) {
        return InsightType.fromString(input.nextString());
    }
}

