package org.openqa.selenium.devtools.v138.network.model;

import org.openqa.selenium.Beta;
import org.openqa.selenium.json.JsonInput;

/**
 * Determines what type of Trust Token operation is executed and
 * depending on the type, some additional parameters. The values
 * are specified in third_party/blink/renderer/core/fetch/trust_token.idl.
 */
@org.openqa.selenium.Beta()
public class TrustTokenParams {

    public enum RefreshPolicy {

        USECACHED("UseCached"), REFRESH("Refresh");

        private String value;

        RefreshPolicy(String value) {
            this.value = value;
        }

        public static RefreshPolicy fromString(String s) {
            return java.util.Arrays.stream(RefreshPolicy.values()).filter(rs -> rs.value.equalsIgnoreCase(s)).findFirst().orElseThrow(() -> new org.openqa.selenium.devtools.DevToolsException("Given value " + s + " is not found within RefreshPolicy "));
        }

        public String toString() {
            return value;
        }

        public String toJson() {
            return value;
        }

        private static RefreshPolicy fromJson(JsonInput input) {
            return fromString(input.nextString());
        }
    }

    private final org.openqa.selenium.devtools.v138.network.model.TrustTokenOperationType operation;

    private final RefreshPolicy refreshPolicy;

    private final java.util.Optional<java.util.List<java.lang.String>> issuers;

    public TrustTokenParams(org.openqa.selenium.devtools.v138.network.model.TrustTokenOperationType operation, RefreshPolicy refreshPolicy, java.util.Optional<java.util.List<java.lang.String>> issuers) {
        this.operation = java.util.Objects.requireNonNull(operation, "operation is required");
        this.refreshPolicy = java.util.Objects.requireNonNull(refreshPolicy, "refreshPolicy is required");
        this.issuers = issuers;
    }

    public org.openqa.selenium.devtools.v138.network.model.TrustTokenOperationType getOperation() {
        return operation;
    }

    /**
     * Only set for "token-redemption" operation and determine whether
     * to request a fresh SRR or use a still valid cached SRR.
     */
    public RefreshPolicy getRefreshPolicy() {
        return refreshPolicy;
    }

    /**
     * Origins of issuers from whom to request tokens or redemption
     * records.
     */
    public java.util.Optional<java.util.List<java.lang.String>> getIssuers() {
        return issuers;
    }

    private static TrustTokenParams fromJson(JsonInput input) {
        org.openqa.selenium.devtools.v138.network.model.TrustTokenOperationType operation = null;
        RefreshPolicy refreshPolicy = null;
        java.util.Optional<java.util.List<java.lang.String>> issuers = java.util.Optional.empty();
        input.beginObject();
        while (input.hasNext()) {
            switch(input.nextName()) {
                case "operation":
                    operation = input.read(org.openqa.selenium.devtools.v138.network.model.TrustTokenOperationType.class);
                    break;
                case "refreshPolicy":
                    refreshPolicy = RefreshPolicy.fromString(input.nextString());
                    break;
                case "issuers":
                    issuers = java.util.Optional.ofNullable(input.readArray(java.lang.String.class));
                    break;
                default:
                    input.skipValue();
                    break;
            }
        }
        input.endObject();
        return new TrustTokenParams(operation, refreshPolicy, issuers);
    }
}
