package org.openqa.selenium.devtools.v138.emulation;

import org.openqa.selenium.Beta;
import org.openqa.selenium.devtools.Command;
import org.openqa.selenium.devtools.Event;
import org.openqa.selenium.devtools.ConverterFunctions;
import java.util.Map;
import java.util.LinkedHashMap;
import org.openqa.selenium.json.JsonInput;

/**
 * This domain emulates different environments for the page.
 */
public class Emulation {

    /**
     * Tells whether emulation is supported.
     */
    @Deprecated()
    public static Command<java.lang.Boolean> canEmulate() {
        LinkedHashMap<String, Object> params = new LinkedHashMap<>();
        return new Command<>("Emulation.canEmulate", Map.copyOf(params), ConverterFunctions.map("result", java.lang.Boolean.class));
    }

    /**
     * Clears the overridden device metrics.
     */
    public static Command<Void> clearDeviceMetricsOverride() {
        LinkedHashMap<String, Object> params = new LinkedHashMap<>();
        return new Command<>("Emulation.clearDeviceMetricsOverride", Map.copyOf(params));
    }

    /**
     * Clears the overridden Geolocation Position and Error.
     */
    public static Command<Void> clearGeolocationOverride() {
        LinkedHashMap<String, Object> params = new LinkedHashMap<>();
        return new Command<>("Emulation.clearGeolocationOverride", Map.copyOf(params));
    }

    /**
     * Requests that page scale factor is reset to initial values.
     */
    @Beta()
    public static Command<Void> resetPageScaleFactor() {
        LinkedHashMap<String, Object> params = new LinkedHashMap<>();
        return new Command<>("Emulation.resetPageScaleFactor", Map.copyOf(params));
    }

    /**
     * Enables or disables simulating a focused and active page.
     */
    @Beta()
    public static Command<Void> setFocusEmulationEnabled(java.lang.Boolean enabled) {
        java.util.Objects.requireNonNull(enabled, "enabled is required");
        LinkedHashMap<String, Object> params = new LinkedHashMap<>();
        params.put("enabled", enabled);
        return new Command<>("Emulation.setFocusEmulationEnabled", Map.copyOf(params));
    }

    /**
     * Automatically render all web contents using a dark theme.
     */
    @Beta()
    public static Command<Void> setAutoDarkModeOverride(java.util.Optional<java.lang.Boolean> enabled) {
        LinkedHashMap<String, Object> params = new LinkedHashMap<>();
        enabled.ifPresent(p -> params.put("enabled", p));
        return new Command<>("Emulation.setAutoDarkModeOverride", Map.copyOf(params));
    }

    /**
     * Enables CPU throttling to emulate slow CPUs.
     */
    public static Command<Void> setCPUThrottlingRate(java.lang.Number rate) {
        java.util.Objects.requireNonNull(rate, "rate is required");
        LinkedHashMap<String, Object> params = new LinkedHashMap<>();
        params.put("rate", rate);
        return new Command<>("Emulation.setCPUThrottlingRate", Map.copyOf(params));
    }

    /**
     * Sets or clears an override of the default background color of the frame. This override is used
     * if the content does not specify one.
     */
    public static Command<Void> setDefaultBackgroundColorOverride(java.util.Optional<org.openqa.selenium.devtools.v138.dom.model.RGBA> color) {
        LinkedHashMap<String, Object> params = new LinkedHashMap<>();
        color.ifPresent(p -> params.put("color", p));
        return new Command<>("Emulation.setDefaultBackgroundColorOverride", Map.copyOf(params));
    }

    /**
     * Overrides the values for env(safe-area-inset-*) and env(safe-area-max-inset-*). Unset values will cause the
     * respective variables to be undefined, even if previously overridden.
     */
    @Beta()
    public static Command<Void> setSafeAreaInsetsOverride(org.openqa.selenium.devtools.v138.emulation.model.SafeAreaInsets insets) {
        java.util.Objects.requireNonNull(insets, "insets is required");
        LinkedHashMap<String, Object> params = new LinkedHashMap<>();
        params.put("insets", insets);
        return new Command<>("Emulation.setSafeAreaInsetsOverride", Map.copyOf(params));
    }

    /**
     * Overrides the values of device screen dimensions (window.screen.width, window.screen.height,
     * window.innerWidth, window.innerHeight, and "device-width"/"device-height"-related CSS media
     * query results).
     */
    public static Command<Void> setDeviceMetricsOverride(java.lang.Integer width, java.lang.Integer height, java.lang.Number deviceScaleFactor, java.lang.Boolean mobile, java.util.Optional<java.lang.Number> scale, java.util.Optional<java.lang.Integer> screenWidth, java.util.Optional<java.lang.Integer> screenHeight, java.util.Optional<java.lang.Integer> positionX, java.util.Optional<java.lang.Integer> positionY, java.util.Optional<java.lang.Boolean> dontSetVisibleSize, java.util.Optional<org.openqa.selenium.devtools.v138.emulation.model.ScreenOrientation> screenOrientation, java.util.Optional<org.openqa.selenium.devtools.v138.page.model.Viewport> viewport, java.util.Optional<org.openqa.selenium.devtools.v138.emulation.model.DisplayFeature> displayFeature, java.util.Optional<org.openqa.selenium.devtools.v138.emulation.model.DevicePosture> devicePosture) {
        java.util.Objects.requireNonNull(width, "width is required");
        java.util.Objects.requireNonNull(height, "height is required");
        java.util.Objects.requireNonNull(deviceScaleFactor, "deviceScaleFactor is required");
        java.util.Objects.requireNonNull(mobile, "mobile is required");
        LinkedHashMap<String, Object> params = new LinkedHashMap<>();
        params.put("width", width);
        params.put("height", height);
        params.put("deviceScaleFactor", deviceScaleFactor);
        params.put("mobile", mobile);
        scale.ifPresent(p -> params.put("scale", p));
        screenWidth.ifPresent(p -> params.put("screenWidth", p));
        screenHeight.ifPresent(p -> params.put("screenHeight", p));
        positionX.ifPresent(p -> params.put("positionX", p));
        positionY.ifPresent(p -> params.put("positionY", p));
        dontSetVisibleSize.ifPresent(p -> params.put("dontSetVisibleSize", p));
        screenOrientation.ifPresent(p -> params.put("screenOrientation", p));
        viewport.ifPresent(p -> params.put("viewport", p));
        displayFeature.ifPresent(p -> params.put("displayFeature", p));
        devicePosture.ifPresent(p -> params.put("devicePosture", p));
        return new Command<>("Emulation.setDeviceMetricsOverride", Map.copyOf(params));
    }

    /**
     * Start reporting the given posture value to the Device Posture API.
     * This override can also be set in setDeviceMetricsOverride().
     */
    @Beta()
    public static Command<Void> setDevicePostureOverride(org.openqa.selenium.devtools.v138.emulation.model.DevicePosture posture) {
        java.util.Objects.requireNonNull(posture, "posture is required");
        LinkedHashMap<String, Object> params = new LinkedHashMap<>();
        params.put("posture", posture);
        return new Command<>("Emulation.setDevicePostureOverride", Map.copyOf(params));
    }

    /**
     * Clears a device posture override set with either setDeviceMetricsOverride()
     * or setDevicePostureOverride() and starts using posture information from the
     * platform again.
     * Does nothing if no override is set.
     */
    @Beta()
    public static Command<Void> clearDevicePostureOverride() {
        LinkedHashMap<String, Object> params = new LinkedHashMap<>();
        return new Command<>("Emulation.clearDevicePostureOverride", Map.copyOf(params));
    }

    /**
     * Start using the given display features to pupulate the Viewport Segments API.
     * This override can also be set in setDeviceMetricsOverride().
     */
    @Beta()
    public static Command<Void> setDisplayFeaturesOverride(java.util.List<org.openqa.selenium.devtools.v138.emulation.model.DisplayFeature> features) {
        java.util.Objects.requireNonNull(features, "features is required");
        LinkedHashMap<String, Object> params = new LinkedHashMap<>();
        params.put("features", features);
        return new Command<>("Emulation.setDisplayFeaturesOverride", Map.copyOf(params));
    }

    /**
     * Clears the display features override set with either setDeviceMetricsOverride()
     * or setDisplayFeaturesOverride() and starts using display features from the
     * platform again.
     * Does nothing if no override is set.
     */
    @Beta()
    public static Command<Void> clearDisplayFeaturesOverride() {
        LinkedHashMap<String, Object> params = new LinkedHashMap<>();
        return new Command<>("Emulation.clearDisplayFeaturesOverride", Map.copyOf(params));
    }

    @Beta()
    public static Command<Void> setScrollbarsHidden(java.lang.Boolean hidden) {
        java.util.Objects.requireNonNull(hidden, "hidden is required");
        LinkedHashMap<String, Object> params = new LinkedHashMap<>();
        params.put("hidden", hidden);
        return new Command<>("Emulation.setScrollbarsHidden", Map.copyOf(params));
    }

    @Beta()
    public static Command<Void> setDocumentCookieDisabled(java.lang.Boolean disabled) {
        java.util.Objects.requireNonNull(disabled, "disabled is required");
        LinkedHashMap<String, Object> params = new LinkedHashMap<>();
        params.put("disabled", disabled);
        return new Command<>("Emulation.setDocumentCookieDisabled", Map.copyOf(params));
    }

    public enum SetEmitTouchEventsForMouseConfiguration {

        MOBILE("mobile"), DESKTOP("desktop");

        private String value;

        SetEmitTouchEventsForMouseConfiguration(String value) {
            this.value = value;
        }

        public static SetEmitTouchEventsForMouseConfiguration fromString(String s) {
            return java.util.Arrays.stream(SetEmitTouchEventsForMouseConfiguration.values()).filter(rs -> rs.value.equalsIgnoreCase(s)).findFirst().orElseThrow(() -> new org.openqa.selenium.devtools.DevToolsException("Given value " + s + " is not found within SetEmitTouchEventsForMouseConfiguration "));
        }

        public String toString() {
            return value;
        }

        public String toJson() {
            return value;
        }

        private static SetEmitTouchEventsForMouseConfiguration fromJson(JsonInput input) {
            return fromString(input.nextString());
        }
    }

    @Beta()
    public static Command<Void> setEmitTouchEventsForMouse(java.lang.Boolean enabled, java.util.Optional<SetEmitTouchEventsForMouseConfiguration> configuration) {
        java.util.Objects.requireNonNull(enabled, "enabled is required");
        LinkedHashMap<String, Object> params = new LinkedHashMap<>();
        params.put("enabled", enabled);
        configuration.ifPresent(p -> params.put("configuration", p));
        return new Command<>("Emulation.setEmitTouchEventsForMouse", Map.copyOf(params));
    }

    /**
     * Emulates the given media type or media feature for CSS media queries.
     */
    public static Command<Void> setEmulatedMedia(java.util.Optional<java.lang.String> media, java.util.Optional<java.util.List<org.openqa.selenium.devtools.v138.emulation.model.MediaFeature>> features) {
        LinkedHashMap<String, Object> params = new LinkedHashMap<>();
        media.ifPresent(p -> params.put("media", p));
        features.ifPresent(p -> params.put("features", p));
        return new Command<>("Emulation.setEmulatedMedia", Map.copyOf(params));
    }

    public enum SetEmulatedVisionDeficiencyType {

        NONE("none"),
        BLURREDVISION("blurredVision"),
        REDUCEDCONTRAST("reducedContrast"),
        ACHROMATOPSIA("achromatopsia"),
        DEUTERANOPIA("deuteranopia"),
        PROTANOPIA("protanopia"),
        TRITANOPIA("tritanopia");

        private String value;

        SetEmulatedVisionDeficiencyType(String value) {
            this.value = value;
        }

        public static SetEmulatedVisionDeficiencyType fromString(String s) {
            return java.util.Arrays.stream(SetEmulatedVisionDeficiencyType.values()).filter(rs -> rs.value.equalsIgnoreCase(s)).findFirst().orElseThrow(() -> new org.openqa.selenium.devtools.DevToolsException("Given value " + s + " is not found within SetEmulatedVisionDeficiencyType "));
        }

        public String toString() {
            return value;
        }

        public String toJson() {
            return value;
        }

        private static SetEmulatedVisionDeficiencyType fromJson(JsonInput input) {
            return fromString(input.nextString());
        }
    }

    /**
     * Emulates the given vision deficiency.
     */
    public static Command<Void> setEmulatedVisionDeficiency(SetEmulatedVisionDeficiencyType type) {
        java.util.Objects.requireNonNull(type, "type is required");
        LinkedHashMap<String, Object> params = new LinkedHashMap<>();
        params.put("type", type);
        return new Command<>("Emulation.setEmulatedVisionDeficiency", Map.copyOf(params));
    }

    /**
     * Overrides the Geolocation Position or Error. Omitting latitude, longitude or
     * accuracy emulates position unavailable.
     */
    public static Command<Void> setGeolocationOverride(java.util.Optional<java.lang.Number> latitude, java.util.Optional<java.lang.Number> longitude, java.util.Optional<java.lang.Number> accuracy, java.util.Optional<java.lang.Number> altitude, java.util.Optional<java.lang.Number> altitudeAccuracy, java.util.Optional<java.lang.Number> heading, java.util.Optional<java.lang.Number> speed) {
        LinkedHashMap<String, Object> params = new LinkedHashMap<>();
        latitude.ifPresent(p -> params.put("latitude", p));
        longitude.ifPresent(p -> params.put("longitude", p));
        accuracy.ifPresent(p -> params.put("accuracy", p));
        altitude.ifPresent(p -> params.put("altitude", p));
        altitudeAccuracy.ifPresent(p -> params.put("altitudeAccuracy", p));
        heading.ifPresent(p -> params.put("heading", p));
        speed.ifPresent(p -> params.put("speed", p));
        return new Command<>("Emulation.setGeolocationOverride", Map.copyOf(params));
    }

    @Beta()
    public static Command<java.lang.Number> getOverriddenSensorInformation(org.openqa.selenium.devtools.v138.emulation.model.SensorType type) {
        java.util.Objects.requireNonNull(type, "type is required");
        LinkedHashMap<String, Object> params = new LinkedHashMap<>();
        params.put("type", type);
        return new Command<>("Emulation.getOverriddenSensorInformation", Map.copyOf(params), ConverterFunctions.map("requestedSamplingFrequency", java.lang.Number.class));
    }

    /**
     * Overrides a platform sensor of a given type. If |enabled| is true, calls to
     * Sensor.start() will use a virtual sensor as backend rather than fetching
     * data from a real hardware sensor. Otherwise, existing virtual
     * sensor-backend Sensor objects will fire an error event and new calls to
     * Sensor.start() will attempt to use a real sensor instead.
     */
    @Beta()
    public static Command<Void> setSensorOverrideEnabled(java.lang.Boolean enabled, org.openqa.selenium.devtools.v138.emulation.model.SensorType type, java.util.Optional<org.openqa.selenium.devtools.v138.emulation.model.SensorMetadata> metadata) {
        java.util.Objects.requireNonNull(enabled, "enabled is required");
        java.util.Objects.requireNonNull(type, "type is required");
        LinkedHashMap<String, Object> params = new LinkedHashMap<>();
        params.put("enabled", enabled);
        params.put("type", type);
        metadata.ifPresent(p -> params.put("metadata", p));
        return new Command<>("Emulation.setSensorOverrideEnabled", Map.copyOf(params));
    }

    /**
     * Updates the sensor readings reported by a sensor type previously overridden
     * by setSensorOverrideEnabled.
     */
    @Beta()
    public static Command<Void> setSensorOverrideReadings(org.openqa.selenium.devtools.v138.emulation.model.SensorType type, org.openqa.selenium.devtools.v138.emulation.model.SensorReading reading) {
        java.util.Objects.requireNonNull(type, "type is required");
        java.util.Objects.requireNonNull(reading, "reading is required");
        LinkedHashMap<String, Object> params = new LinkedHashMap<>();
        params.put("type", type);
        params.put("reading", reading);
        return new Command<>("Emulation.setSensorOverrideReadings", Map.copyOf(params));
    }

    /**
     * Overrides a pressure source of a given type, as used by the Compute
     * Pressure API, so that updates to PressureObserver.observe() are provided
     * via setPressureStateOverride instead of being retrieved from
     * platform-provided telemetry data.
     */
    @Beta()
    public static Command<Void> setPressureSourceOverrideEnabled(java.lang.Boolean enabled, org.openqa.selenium.devtools.v138.emulation.model.PressureSource source, java.util.Optional<org.openqa.selenium.devtools.v138.emulation.model.PressureMetadata> metadata) {
        java.util.Objects.requireNonNull(enabled, "enabled is required");
        java.util.Objects.requireNonNull(source, "source is required");
        LinkedHashMap<String, Object> params = new LinkedHashMap<>();
        params.put("enabled", enabled);
        params.put("source", source);
        metadata.ifPresent(p -> params.put("metadata", p));
        return new Command<>("Emulation.setPressureSourceOverrideEnabled", Map.copyOf(params));
    }

    /**
     * TODO: OBSOLETE: To remove when setPressureDataOverride is merged.
     * Provides a given pressure state that will be processed and eventually be
     * delivered to PressureObserver users. |source| must have been previously
     * overridden by setPressureSourceOverrideEnabled.
     */
    @Beta()
    public static Command<Void> setPressureStateOverride(org.openqa.selenium.devtools.v138.emulation.model.PressureSource source, org.openqa.selenium.devtools.v138.emulation.model.PressureState state) {
        java.util.Objects.requireNonNull(source, "source is required");
        java.util.Objects.requireNonNull(state, "state is required");
        LinkedHashMap<String, Object> params = new LinkedHashMap<>();
        params.put("source", source);
        params.put("state", state);
        return new Command<>("Emulation.setPressureStateOverride", Map.copyOf(params));
    }

    /**
     * Provides a given pressure data set that will be processed and eventually be
     * delivered to PressureObserver users. |source| must have been previously
     * overridden by setPressureSourceOverrideEnabled.
     */
    @Beta()
    public static Command<Void> setPressureDataOverride(org.openqa.selenium.devtools.v138.emulation.model.PressureSource source, org.openqa.selenium.devtools.v138.emulation.model.PressureState state, java.util.Optional<java.lang.Number> ownContributionEstimate) {
        java.util.Objects.requireNonNull(source, "source is required");
        java.util.Objects.requireNonNull(state, "state is required");
        LinkedHashMap<String, Object> params = new LinkedHashMap<>();
        params.put("source", source);
        params.put("state", state);
        ownContributionEstimate.ifPresent(p -> params.put("ownContributionEstimate", p));
        return new Command<>("Emulation.setPressureDataOverride", Map.copyOf(params));
    }

    /**
     * Overrides the Idle state.
     */
    public static Command<Void> setIdleOverride(java.lang.Boolean isUserActive, java.lang.Boolean isScreenUnlocked) {
        java.util.Objects.requireNonNull(isUserActive, "isUserActive is required");
        java.util.Objects.requireNonNull(isScreenUnlocked, "isScreenUnlocked is required");
        LinkedHashMap<String, Object> params = new LinkedHashMap<>();
        params.put("isUserActive", isUserActive);
        params.put("isScreenUnlocked", isScreenUnlocked);
        return new Command<>("Emulation.setIdleOverride", Map.copyOf(params));
    }

    /**
     * Clears Idle state overrides.
     */
    public static Command<Void> clearIdleOverride() {
        LinkedHashMap<String, Object> params = new LinkedHashMap<>();
        return new Command<>("Emulation.clearIdleOverride", Map.copyOf(params));
    }

    /**
     * Overrides value returned by the javascript navigator object.
     */
    @Beta()
    @Deprecated()
    public static Command<Void> setNavigatorOverrides(java.lang.String platform) {
        java.util.Objects.requireNonNull(platform, "platform is required");
        LinkedHashMap<String, Object> params = new LinkedHashMap<>();
        params.put("platform", platform);
        return new Command<>("Emulation.setNavigatorOverrides", Map.copyOf(params));
    }

    /**
     * Sets a specified page scale factor.
     */
    @Beta()
    public static Command<Void> setPageScaleFactor(java.lang.Number pageScaleFactor) {
        java.util.Objects.requireNonNull(pageScaleFactor, "pageScaleFactor is required");
        LinkedHashMap<String, Object> params = new LinkedHashMap<>();
        params.put("pageScaleFactor", pageScaleFactor);
        return new Command<>("Emulation.setPageScaleFactor", Map.copyOf(params));
    }

    /**
     * Switches script execution in the page.
     */
    public static Command<Void> setScriptExecutionDisabled(java.lang.Boolean value) {
        java.util.Objects.requireNonNull(value, "value is required");
        LinkedHashMap<String, Object> params = new LinkedHashMap<>();
        params.put("value", value);
        return new Command<>("Emulation.setScriptExecutionDisabled", Map.copyOf(params));
    }

    /**
     * Enables touch on platforms which do not support them.
     */
    public static Command<Void> setTouchEmulationEnabled(java.lang.Boolean enabled, java.util.Optional<java.lang.Integer> maxTouchPoints) {
        java.util.Objects.requireNonNull(enabled, "enabled is required");
        LinkedHashMap<String, Object> params = new LinkedHashMap<>();
        params.put("enabled", enabled);
        maxTouchPoints.ifPresent(p -> params.put("maxTouchPoints", p));
        return new Command<>("Emulation.setTouchEmulationEnabled", Map.copyOf(params));
    }

    /**
     * Turns on virtual time for all frames (replacing real-time with a synthetic time source) and sets
     * the current virtual time policy.  Note this supersedes any previous time budget.
     */
    @Beta()
    public static Command<java.lang.Number> setVirtualTimePolicy(org.openqa.selenium.devtools.v138.emulation.model.VirtualTimePolicy policy, java.util.Optional<java.lang.Number> budget, java.util.Optional<java.lang.Integer> maxVirtualTimeTaskStarvationCount, java.util.Optional<org.openqa.selenium.devtools.v138.network.model.TimeSinceEpoch> initialVirtualTime) {
        java.util.Objects.requireNonNull(policy, "policy is required");
        LinkedHashMap<String, Object> params = new LinkedHashMap<>();
        params.put("policy", policy);
        budget.ifPresent(p -> params.put("budget", p));
        maxVirtualTimeTaskStarvationCount.ifPresent(p -> params.put("maxVirtualTimeTaskStarvationCount", p));
        initialVirtualTime.ifPresent(p -> params.put("initialVirtualTime", p));
        return new Command<>("Emulation.setVirtualTimePolicy", Map.copyOf(params), ConverterFunctions.map("virtualTimeTicksBase", java.lang.Number.class));
    }

    /**
     * Overrides default host system locale with the specified one.
     */
    @Beta()
    public static Command<Void> setLocaleOverride(java.util.Optional<java.lang.String> locale) {
        LinkedHashMap<String, Object> params = new LinkedHashMap<>();
        locale.ifPresent(p -> params.put("locale", p));
        return new Command<>("Emulation.setLocaleOverride", Map.copyOf(params));
    }

    /**
     * Overrides default host system timezone with the specified one.
     */
    public static Command<Void> setTimezoneOverride(java.lang.String timezoneId) {
        java.util.Objects.requireNonNull(timezoneId, "timezoneId is required");
        LinkedHashMap<String, Object> params = new LinkedHashMap<>();
        params.put("timezoneId", timezoneId);
        return new Command<>("Emulation.setTimezoneOverride", Map.copyOf(params));
    }

    /**
     * Resizes the frame/viewport of the page. Note that this does not affect the frame's container
     * (e.g. browser window). Can be used to produce screenshots of the specified size. Not supported
     * on Android.
     */
    @Beta()
    @Deprecated()
    public static Command<Void> setVisibleSize(java.lang.Integer width, java.lang.Integer height) {
        java.util.Objects.requireNonNull(width, "width is required");
        java.util.Objects.requireNonNull(height, "height is required");
        LinkedHashMap<String, Object> params = new LinkedHashMap<>();
        params.put("width", width);
        params.put("height", height);
        return new Command<>("Emulation.setVisibleSize", Map.copyOf(params));
    }

    @Beta()
    public static Command<Void> setDisabledImageTypes(java.util.List<org.openqa.selenium.devtools.v138.emulation.model.DisabledImageType> imageTypes) {
        java.util.Objects.requireNonNull(imageTypes, "imageTypes is required");
        LinkedHashMap<String, Object> params = new LinkedHashMap<>();
        params.put("imageTypes", imageTypes);
        return new Command<>("Emulation.setDisabledImageTypes", Map.copyOf(params));
    }

    @Beta()
    public static Command<Void> setHardwareConcurrencyOverride(java.lang.Integer hardwareConcurrency) {
        java.util.Objects.requireNonNull(hardwareConcurrency, "hardwareConcurrency is required");
        LinkedHashMap<String, Object> params = new LinkedHashMap<>();
        params.put("hardwareConcurrency", hardwareConcurrency);
        return new Command<>("Emulation.setHardwareConcurrencyOverride", Map.copyOf(params));
    }

    /**
     * Allows overriding user agent with the given string.
     * `userAgentMetadata` must be set for Client Hint headers to be sent.
     */
    public static Command<Void> setUserAgentOverride(java.lang.String userAgent, java.util.Optional<java.lang.String> acceptLanguage, java.util.Optional<java.lang.String> platform, java.util.Optional<org.openqa.selenium.devtools.v138.emulation.model.UserAgentMetadata> userAgentMetadata) {
        java.util.Objects.requireNonNull(userAgent, "userAgent is required");
        LinkedHashMap<String, Object> params = new LinkedHashMap<>();
        params.put("userAgent", userAgent);
        acceptLanguage.ifPresent(p -> params.put("acceptLanguage", p));
        platform.ifPresent(p -> params.put("platform", p));
        userAgentMetadata.ifPresent(p -> params.put("userAgentMetadata", p));
        return new Command<>("Emulation.setUserAgentOverride", Map.copyOf(params));
    }

    /**
     * Allows overriding the automation flag.
     */
    @Beta()
    public static Command<Void> setAutomationOverride(java.lang.Boolean enabled) {
        java.util.Objects.requireNonNull(enabled, "enabled is required");
        LinkedHashMap<String, Object> params = new LinkedHashMap<>();
        params.put("enabled", enabled);
        return new Command<>("Emulation.setAutomationOverride", Map.copyOf(params));
    }

    /**
     * Allows overriding the difference between the small and large viewport sizes, which determine the
     * value of the `svh` and `lvh` unit, respectively. Only supported for top-level frames.
     */
    @Beta()
    public static Command<Void> setSmallViewportHeightDifferenceOverride(java.lang.Integer difference) {
        java.util.Objects.requireNonNull(difference, "difference is required");
        LinkedHashMap<String, Object> params = new LinkedHashMap<>();
        params.put("difference", difference);
        return new Command<>("Emulation.setSmallViewportHeightDifferenceOverride", Map.copyOf(params));
    }

    public static Event<Void> virtualTimeBudgetExpired() {
        return new Event<>("Emulation.virtualTimeBudgetExpired", ConverterFunctions.empty());
    }
}
