package org.openqa.selenium.devtools.v138.css.model;

import org.openqa.selenium.Beta;
import org.openqa.selenium.json.JsonInput;

/**
 * Data for a simple selector (these are delimited by commas in a selector list).
 */
public class Value {

    private final java.lang.String text;

    private final java.util.Optional<org.openqa.selenium.devtools.v138.css.model.SourceRange> range;

    private final java.util.Optional<org.openqa.selenium.devtools.v138.css.model.Specificity> specificity;

    public Value(java.lang.String text, java.util.Optional<org.openqa.selenium.devtools.v138.css.model.SourceRange> range, java.util.Optional<org.openqa.selenium.devtools.v138.css.model.Specificity> specificity) {
        this.text = java.util.Objects.requireNonNull(text, "text is required");
        this.range = range;
        this.specificity = specificity;
    }

    /**
     * Value text.
     */
    public java.lang.String getText() {
        return text;
    }

    /**
     * Value range in the underlying resource (if available).
     */
    public java.util.Optional<org.openqa.selenium.devtools.v138.css.model.SourceRange> getRange() {
        return range;
    }

    /**
     * Specificity of the selector.
     */
    @Beta()
    public java.util.Optional<org.openqa.selenium.devtools.v138.css.model.Specificity> getSpecificity() {
        return specificity;
    }

    private static Value fromJson(JsonInput input) {
        java.lang.String text = null;
        java.util.Optional<org.openqa.selenium.devtools.v138.css.model.SourceRange> range = java.util.Optional.empty();
        java.util.Optional<org.openqa.selenium.devtools.v138.css.model.Specificity> specificity = java.util.Optional.empty();
        input.beginObject();
        while (input.hasNext()) {
            switch(input.nextName()) {
                case "text":
                    text = input.nextString();
                    break;
                case "range":
                    range = java.util.Optional.ofNullable(input.read(org.openqa.selenium.devtools.v138.css.model.SourceRange.class));
                    break;
                case "specificity":
                    specificity = java.util.Optional.ofNullable(input.read(org.openqa.selenium.devtools.v138.css.model.Specificity.class));
                    break;
                default:
                    input.skipValue();
                    break;
            }
        }
        input.endObject();
        return new Value(text, range, specificity);
    }
}
