package org.openqa.selenium.devtools.v138.audits.model;

import org.openqa.selenium.Beta;
import org.openqa.selenium.json.JsonInput;

/**
 * Represents the category of insight that a cookie issue falls under.
 */
public enum InsightType {

    GITHUBRESOURCE("GitHubResource"), GRACEPERIOD("GracePeriod"), HEURISTICS("Heuristics");

    private String value;

    InsightType(String value) {
        this.value = value;
    }

    public static InsightType fromString(String s) {
        return java.util.Arrays.stream(InsightType.values()).filter(rs -> rs.value.equalsIgnoreCase(s)).findFirst().orElseThrow(() -> new org.openqa.selenium.devtools.DevToolsException("Given value " + s + " is not found within InsightType "));
    }

    public String toString() {
        return value;
    }

    public String toJson() {
        return value;
    }

    private static InsightType fromJson(JsonInput input) {
        return fromString(input.nextString());
    }
}
