package org.openqa.selenium.devtools.v137.audits.model;

import org.openqa.selenium.Beta;
import org.openqa.selenium.json.JsonInput;

/**
 * Information about the suggested solution to a cookie issue.
 */
public class CookieIssueInsight {

    private final org.openqa.selenium.devtools.v137.audits.model.InsightType type;

    private final java.util.Optional<java.lang.String> tableEntryUrl;

    public CookieIssueInsight(org.openqa.selenium.devtools.v137.audits.model.InsightType type, java.util.Optional<java.lang.String> tableEntryUrl) {
        this.type = java.util.Objects.requireNonNull(type, "type is required");
        this.tableEntryUrl = tableEntryUrl;
    }

    public org.openqa.selenium.devtools.v137.audits.model.InsightType getType() {
        return type;
    }

    /**
     * Link to table entry in third-party cookie migration readiness list.
     */
    public java.util.Optional<java.lang.String> getTableEntryUrl() {
        return tableEntryUrl;
    }

    private static CookieIssueInsight fromJson(JsonInput input) {
        org.openqa.selenium.devtools.v137.audits.model.InsightType type = null;
        java.util.Optional<java.lang.String> tableEntryUrl = java.util.Optional.empty();
        input.beginObject();
        while (input.hasNext()) {
            switch(input.nextName()) {
                case "type":
                    type = input.read(org.openqa.selenium.devtools.v137.audits.model.InsightType.class);
                    break;
                case "tableEntryUrl":
                    tableEntryUrl = java.util.Optional.ofNullable(input.nextString());
                    break;
                default:
                    input.skipValue();
                    break;
            }
        }
        input.endObject();
        return new CookieIssueInsight(type, tableEntryUrl);
    }
}
