package org.openqa.selenium.devtools.v136.audits.model;

import org.openqa.selenium.Beta;
import org.openqa.selenium.json.JsonInput;

/**
 * Information about a request that is affected by an inspector issue.
 */
public class AffectedRequest {

    private final java.util.Optional<org.openqa.selenium.devtools.v136.network.model.RequestId> requestId;

    private final java.lang.String url;

    public AffectedRequest(java.util.Optional<org.openqa.selenium.devtools.v136.network.model.RequestId> requestId, java.lang.String url) {
        this.requestId = requestId;
        this.url = java.util.Objects.requireNonNull(url, "url is required");
    }

    /**
     * The unique request id.
     */
    public java.util.Optional<org.openqa.selenium.devtools.v136.network.model.RequestId> getRequestId() {
        return requestId;
    }

    public java.lang.String getUrl() {
        return url;
    }

    private static AffectedRequest fromJson(JsonInput input) {
        java.util.Optional<org.openqa.selenium.devtools.v136.network.model.RequestId> requestId = java.util.Optional.empty();
        java.lang.String url = null;
        input.beginObject();
        while (input.hasNext()) {
            switch(input.nextName()) {
                case "requestId":
                    requestId = java.util.Optional.ofNullable(input.read(org.openqa.selenium.devtools.v136.network.model.RequestId.class));
                    break;
                case "url":
                    url = input.nextString();
                    break;
                default:
                    input.skipValue();
                    break;
            }
        }
        input.endObject();
        return new AffectedRequest(requestId, url);
    }
}
