/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.devtools.v136.emulation;

import java.io.Serializable;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.openqa.selenium.Beta;
import org.openqa.selenium.devtools.Command;
import org.openqa.selenium.devtools.ConverterFunctions;
import org.openqa.selenium.devtools.DevToolsException;
import org.openqa.selenium.devtools.Event;
import org.openqa.selenium.devtools.v136.dom.model.RGBA;
import org.openqa.selenium.devtools.v136.emulation.model.DevicePosture;
import org.openqa.selenium.devtools.v136.emulation.model.DisabledImageType;
import org.openqa.selenium.devtools.v136.emulation.model.DisplayFeature;
import org.openqa.selenium.devtools.v136.emulation.model.MediaFeature;
import org.openqa.selenium.devtools.v136.emulation.model.PressureMetadata;
import org.openqa.selenium.devtools.v136.emulation.model.PressureSource;
import org.openqa.selenium.devtools.v136.emulation.model.PressureState;
import org.openqa.selenium.devtools.v136.emulation.model.SafeAreaInsets;
import org.openqa.selenium.devtools.v136.emulation.model.ScreenOrientation;
import org.openqa.selenium.devtools.v136.emulation.model.SensorMetadata;
import org.openqa.selenium.devtools.v136.emulation.model.SensorReading;
import org.openqa.selenium.devtools.v136.emulation.model.SensorType;
import org.openqa.selenium.devtools.v136.emulation.model.UserAgentMetadata;
import org.openqa.selenium.devtools.v136.emulation.model.VirtualTimePolicy;
import org.openqa.selenium.devtools.v136.network.model.TimeSinceEpoch;
import org.openqa.selenium.devtools.v136.page.model.Viewport;
import org.openqa.selenium.json.JsonInput;

public class Emulation {
    @Deprecated
    public static Command<Boolean> canEmulate() {
        LinkedHashMap params = new LinkedHashMap();
        return new Command("Emulation.canEmulate", Map.copyOf(params), ConverterFunctions.map((String)"result", Boolean.class));
    }

    public static Command<Void> clearDeviceMetricsOverride() {
        LinkedHashMap params = new LinkedHashMap();
        return new Command("Emulation.clearDeviceMetricsOverride", Map.copyOf(params));
    }

    public static Command<Void> clearGeolocationOverride() {
        LinkedHashMap params = new LinkedHashMap();
        return new Command("Emulation.clearGeolocationOverride", Map.copyOf(params));
    }

    @Beta
    public static Command<Void> resetPageScaleFactor() {
        LinkedHashMap params = new LinkedHashMap();
        return new Command("Emulation.resetPageScaleFactor", Map.copyOf(params));
    }

    @Beta
    public static Command<Void> setFocusEmulationEnabled(Boolean enabled) {
        Objects.requireNonNull(enabled, "enabled is required");
        LinkedHashMap<String, Boolean> params = new LinkedHashMap<String, Boolean>();
        params.put("enabled", enabled);
        return new Command("Emulation.setFocusEmulationEnabled", Map.copyOf(params));
    }

    @Beta
    public static Command<Void> setAutoDarkModeOverride(Optional<Boolean> enabled) {
        LinkedHashMap params = new LinkedHashMap();
        enabled.ifPresent(p -> params.put("enabled", p));
        return new Command("Emulation.setAutoDarkModeOverride", Map.copyOf(params));
    }

    public static Command<Void> setCPUThrottlingRate(Number rate) {
        Objects.requireNonNull(rate, "rate is required");
        LinkedHashMap<String, Number> params = new LinkedHashMap<String, Number>();
        params.put("rate", rate);
        return new Command("Emulation.setCPUThrottlingRate", Map.copyOf(params));
    }

    public static Command<Void> setDefaultBackgroundColorOverride(Optional<RGBA> color) {
        LinkedHashMap params = new LinkedHashMap();
        color.ifPresent(p -> params.put("color", p));
        return new Command("Emulation.setDefaultBackgroundColorOverride", Map.copyOf(params));
    }

    @Beta
    public static Command<Void> setSafeAreaInsetsOverride(SafeAreaInsets insets) {
        Objects.requireNonNull(insets, "insets is required");
        LinkedHashMap<String, SafeAreaInsets> params = new LinkedHashMap<String, SafeAreaInsets>();
        params.put("insets", insets);
        return new Command("Emulation.setSafeAreaInsetsOverride", Map.copyOf(params));
    }

    public static Command<Void> setDeviceMetricsOverride(Integer width, Integer height, Number deviceScaleFactor, Boolean mobile, Optional<Number> scale, Optional<Integer> screenWidth, Optional<Integer> screenHeight, Optional<Integer> positionX, Optional<Integer> positionY, Optional<Boolean> dontSetVisibleSize, Optional<ScreenOrientation> screenOrientation, Optional<Viewport> viewport, Optional<DisplayFeature> displayFeature, Optional<DevicePosture> devicePosture) {
        Objects.requireNonNull(width, "width is required");
        Objects.requireNonNull(height, "height is required");
        Objects.requireNonNull(deviceScaleFactor, "deviceScaleFactor is required");
        Objects.requireNonNull(mobile, "mobile is required");
        LinkedHashMap<String, Serializable> params = new LinkedHashMap<String, Serializable>();
        params.put("width", width);
        params.put("height", height);
        params.put("deviceScaleFactor", deviceScaleFactor);
        params.put("mobile", mobile);
        scale.ifPresent(p -> params.put("scale", (Serializable)p));
        screenWidth.ifPresent(p -> params.put("screenWidth", (Serializable)p));
        screenHeight.ifPresent(p -> params.put("screenHeight", (Serializable)p));
        positionX.ifPresent(p -> params.put("positionX", (Serializable)p));
        positionY.ifPresent(p -> params.put("positionY", (Serializable)p));
        dontSetVisibleSize.ifPresent(p -> params.put("dontSetVisibleSize", (Serializable)p));
        screenOrientation.ifPresent(p -> params.put("screenOrientation", (Serializable)p));
        viewport.ifPresent(p -> params.put("viewport", (Serializable)p));
        displayFeature.ifPresent(p -> params.put("displayFeature", (Serializable)p));
        devicePosture.ifPresent(p -> params.put("devicePosture", (Serializable)p));
        return new Command("Emulation.setDeviceMetricsOverride", Map.copyOf(params));
    }

    @Beta
    public static Command<Void> setDevicePostureOverride(DevicePosture posture) {
        Objects.requireNonNull(posture, "posture is required");
        LinkedHashMap<String, DevicePosture> params = new LinkedHashMap<String, DevicePosture>();
        params.put("posture", posture);
        return new Command("Emulation.setDevicePostureOverride", Map.copyOf(params));
    }

    @Beta
    public static Command<Void> clearDevicePostureOverride() {
        LinkedHashMap params = new LinkedHashMap();
        return new Command("Emulation.clearDevicePostureOverride", Map.copyOf(params));
    }

    @Beta
    public static Command<Void> setDisplayFeaturesOverride(List<DisplayFeature> features) {
        Objects.requireNonNull(features, "features is required");
        LinkedHashMap<String, List<DisplayFeature>> params = new LinkedHashMap<String, List<DisplayFeature>>();
        params.put("features", features);
        return new Command("Emulation.setDisplayFeaturesOverride", Map.copyOf(params));
    }

    @Beta
    public static Command<Void> clearDisplayFeaturesOverride() {
        LinkedHashMap params = new LinkedHashMap();
        return new Command("Emulation.clearDisplayFeaturesOverride", Map.copyOf(params));
    }

    @Beta
    public static Command<Void> setScrollbarsHidden(Boolean hidden) {
        Objects.requireNonNull(hidden, "hidden is required");
        LinkedHashMap<String, Boolean> params = new LinkedHashMap<String, Boolean>();
        params.put("hidden", hidden);
        return new Command("Emulation.setScrollbarsHidden", Map.copyOf(params));
    }

    @Beta
    public static Command<Void> setDocumentCookieDisabled(Boolean disabled) {
        Objects.requireNonNull(disabled, "disabled is required");
        LinkedHashMap<String, Boolean> params = new LinkedHashMap<String, Boolean>();
        params.put("disabled", disabled);
        return new Command("Emulation.setDocumentCookieDisabled", Map.copyOf(params));
    }

    @Beta
    public static Command<Void> setEmitTouchEventsForMouse(Boolean enabled, Optional<SetEmitTouchEventsForMouseConfiguration> configuration) {
        Objects.requireNonNull(enabled, "enabled is required");
        LinkedHashMap<String, Boolean> params = new LinkedHashMap<String, Boolean>();
        params.put("enabled", enabled);
        configuration.ifPresent(p -> params.put("configuration", (Boolean)p));
        return new Command("Emulation.setEmitTouchEventsForMouse", Map.copyOf(params));
    }

    public static Command<Void> setEmulatedMedia(Optional<String> media, Optional<List<MediaFeature>> features) {
        LinkedHashMap params = new LinkedHashMap();
        media.ifPresent(p -> params.put("media", p));
        features.ifPresent(p -> params.put("features", p));
        return new Command("Emulation.setEmulatedMedia", Map.copyOf(params));
    }

    public static Command<Void> setEmulatedVisionDeficiency(SetEmulatedVisionDeficiencyType type) {
        Objects.requireNonNull(type, "type is required");
        LinkedHashMap<String, SetEmulatedVisionDeficiencyType> params = new LinkedHashMap<String, SetEmulatedVisionDeficiencyType>();
        params.put("type", type);
        return new Command("Emulation.setEmulatedVisionDeficiency", Map.copyOf(params));
    }

    public static Command<Void> setGeolocationOverride(Optional<Number> latitude, Optional<Number> longitude, Optional<Number> accuracy) {
        LinkedHashMap params = new LinkedHashMap();
        latitude.ifPresent(p -> params.put("latitude", p));
        longitude.ifPresent(p -> params.put("longitude", p));
        accuracy.ifPresent(p -> params.put("accuracy", p));
        return new Command("Emulation.setGeolocationOverride", Map.copyOf(params));
    }

    @Beta
    public static Command<Number> getOverriddenSensorInformation(SensorType type) {
        Objects.requireNonNull(type, "type is required");
        LinkedHashMap<String, SensorType> params = new LinkedHashMap<String, SensorType>();
        params.put("type", type);
        return new Command("Emulation.getOverriddenSensorInformation", Map.copyOf(params), ConverterFunctions.map((String)"requestedSamplingFrequency", Number.class));
    }

    @Beta
    public static Command<Void> setSensorOverrideEnabled(Boolean enabled, SensorType type, Optional<SensorMetadata> metadata) {
        Objects.requireNonNull(enabled, "enabled is required");
        Objects.requireNonNull(type, "type is required");
        LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
        params.put("enabled", enabled);
        params.put("type", (Object)type);
        metadata.ifPresent(p -> params.put("metadata", p));
        return new Command("Emulation.setSensorOverrideEnabled", Map.copyOf(params));
    }

    @Beta
    public static Command<Void> setSensorOverrideReadings(SensorType type, SensorReading reading) {
        Objects.requireNonNull(type, "type is required");
        Objects.requireNonNull(reading, "reading is required");
        LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
        params.put("type", (Object)type);
        params.put("reading", reading);
        return new Command("Emulation.setSensorOverrideReadings", Map.copyOf(params));
    }

    @Beta
    public static Command<Void> setPressureSourceOverrideEnabled(Boolean enabled, PressureSource source, Optional<PressureMetadata> metadata) {
        Objects.requireNonNull(enabled, "enabled is required");
        Objects.requireNonNull(source, "source is required");
        LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
        params.put("enabled", enabled);
        params.put("source", (Object)source);
        metadata.ifPresent(p -> params.put("metadata", p));
        return new Command("Emulation.setPressureSourceOverrideEnabled", Map.copyOf(params));
    }

    @Beta
    public static Command<Void> setPressureStateOverride(PressureSource source, PressureState state) {
        Objects.requireNonNull(source, "source is required");
        Objects.requireNonNull(state, "state is required");
        LinkedHashMap<String, Enum> params = new LinkedHashMap<String, Enum>();
        params.put("source", source);
        params.put("state", state);
        return new Command("Emulation.setPressureStateOverride", Map.copyOf(params));
    }

    public static Command<Void> setIdleOverride(Boolean isUserActive, Boolean isScreenUnlocked) {
        Objects.requireNonNull(isUserActive, "isUserActive is required");
        Objects.requireNonNull(isScreenUnlocked, "isScreenUnlocked is required");
        LinkedHashMap<String, Boolean> params = new LinkedHashMap<String, Boolean>();
        params.put("isUserActive", isUserActive);
        params.put("isScreenUnlocked", isScreenUnlocked);
        return new Command("Emulation.setIdleOverride", Map.copyOf(params));
    }

    public static Command<Void> clearIdleOverride() {
        LinkedHashMap params = new LinkedHashMap();
        return new Command("Emulation.clearIdleOverride", Map.copyOf(params));
    }

    @Beta
    @Deprecated
    public static Command<Void> setNavigatorOverrides(String platform) {
        Objects.requireNonNull(platform, "platform is required");
        LinkedHashMap<String, String> params = new LinkedHashMap<String, String>();
        params.put("platform", platform);
        return new Command("Emulation.setNavigatorOverrides", Map.copyOf(params));
    }

    @Beta
    public static Command<Void> setPageScaleFactor(Number pageScaleFactor) {
        Objects.requireNonNull(pageScaleFactor, "pageScaleFactor is required");
        LinkedHashMap<String, Number> params = new LinkedHashMap<String, Number>();
        params.put("pageScaleFactor", pageScaleFactor);
        return new Command("Emulation.setPageScaleFactor", Map.copyOf(params));
    }

    public static Command<Void> setScriptExecutionDisabled(Boolean value) {
        Objects.requireNonNull(value, "value is required");
        LinkedHashMap<String, Boolean> params = new LinkedHashMap<String, Boolean>();
        params.put("value", value);
        return new Command("Emulation.setScriptExecutionDisabled", Map.copyOf(params));
    }

    public static Command<Void> setTouchEmulationEnabled(Boolean enabled, Optional<Integer> maxTouchPoints) {
        Objects.requireNonNull(enabled, "enabled is required");
        LinkedHashMap<String, Boolean> params = new LinkedHashMap<String, Boolean>();
        params.put("enabled", enabled);
        maxTouchPoints.ifPresent(p -> params.put("maxTouchPoints", (Boolean)p));
        return new Command("Emulation.setTouchEmulationEnabled", Map.copyOf(params));
    }

    @Beta
    public static Command<Number> setVirtualTimePolicy(VirtualTimePolicy policy, Optional<Number> budget, Optional<Integer> maxVirtualTimeTaskStarvationCount, Optional<TimeSinceEpoch> initialVirtualTime) {
        Objects.requireNonNull(policy, "policy is required");
        LinkedHashMap<String, VirtualTimePolicy> params = new LinkedHashMap<String, VirtualTimePolicy>();
        params.put("policy", policy);
        budget.ifPresent(p -> params.put("budget", (VirtualTimePolicy)((Object)p)));
        maxVirtualTimeTaskStarvationCount.ifPresent(p -> params.put("maxVirtualTimeTaskStarvationCount", (VirtualTimePolicy)((Object)p)));
        initialVirtualTime.ifPresent(p -> params.put("initialVirtualTime", (VirtualTimePolicy)((Object)p)));
        return new Command("Emulation.setVirtualTimePolicy", Map.copyOf(params), ConverterFunctions.map((String)"virtualTimeTicksBase", Number.class));
    }

    @Beta
    public static Command<Void> setLocaleOverride(Optional<String> locale) {
        LinkedHashMap params = new LinkedHashMap();
        locale.ifPresent(p -> params.put("locale", p));
        return new Command("Emulation.setLocaleOverride", Map.copyOf(params));
    }

    public static Command<Void> setTimezoneOverride(String timezoneId) {
        Objects.requireNonNull(timezoneId, "timezoneId is required");
        LinkedHashMap<String, String> params = new LinkedHashMap<String, String>();
        params.put("timezoneId", timezoneId);
        return new Command("Emulation.setTimezoneOverride", Map.copyOf(params));
    }

    @Beta
    @Deprecated
    public static Command<Void> setVisibleSize(Integer width, Integer height) {
        Objects.requireNonNull(width, "width is required");
        Objects.requireNonNull(height, "height is required");
        LinkedHashMap<String, Integer> params = new LinkedHashMap<String, Integer>();
        params.put("width", width);
        params.put("height", height);
        return new Command("Emulation.setVisibleSize", Map.copyOf(params));
    }

    @Beta
    public static Command<Void> setDisabledImageTypes(List<DisabledImageType> imageTypes) {
        Objects.requireNonNull(imageTypes, "imageTypes is required");
        LinkedHashMap<String, List<DisabledImageType>> params = new LinkedHashMap<String, List<DisabledImageType>>();
        params.put("imageTypes", imageTypes);
        return new Command("Emulation.setDisabledImageTypes", Map.copyOf(params));
    }

    @Beta
    public static Command<Void> setHardwareConcurrencyOverride(Integer hardwareConcurrency) {
        Objects.requireNonNull(hardwareConcurrency, "hardwareConcurrency is required");
        LinkedHashMap<String, Integer> params = new LinkedHashMap<String, Integer>();
        params.put("hardwareConcurrency", hardwareConcurrency);
        return new Command("Emulation.setHardwareConcurrencyOverride", Map.copyOf(params));
    }

    public static Command<Void> setUserAgentOverride(String userAgent, Optional<String> acceptLanguage, Optional<String> platform, Optional<UserAgentMetadata> userAgentMetadata) {
        Objects.requireNonNull(userAgent, "userAgent is required");
        LinkedHashMap<String, String> params = new LinkedHashMap<String, String>();
        params.put("userAgent", userAgent);
        acceptLanguage.ifPresent(p -> params.put("acceptLanguage", (String)p));
        platform.ifPresent(p -> params.put("platform", (String)p));
        userAgentMetadata.ifPresent(p -> params.put("userAgentMetadata", (String)p));
        return new Command("Emulation.setUserAgentOverride", Map.copyOf(params));
    }

    @Beta
    public static Command<Void> setAutomationOverride(Boolean enabled) {
        Objects.requireNonNull(enabled, "enabled is required");
        LinkedHashMap<String, Boolean> params = new LinkedHashMap<String, Boolean>();
        params.put("enabled", enabled);
        return new Command("Emulation.setAutomationOverride", Map.copyOf(params));
    }

    public static Event<Void> virtualTimeBudgetExpired() {
        return new Event("Emulation.virtualTimeBudgetExpired", ConverterFunctions.empty());
    }

    public static enum SetEmulatedVisionDeficiencyType {
        NONE("none"),
        BLURREDVISION("blurredVision"),
        REDUCEDCONTRAST("reducedContrast"),
        ACHROMATOPSIA("achromatopsia"),
        DEUTERANOPIA("deuteranopia"),
        PROTANOPIA("protanopia"),
        TRITANOPIA("tritanopia");

        private String value;

        private SetEmulatedVisionDeficiencyType(String value) {
            this.value = value;
        }

        public static SetEmulatedVisionDeficiencyType fromString(String s) {
            return Arrays.stream(SetEmulatedVisionDeficiencyType.values()).filter(rs -> rs.value.equalsIgnoreCase(s)).findFirst().orElseThrow(() -> new DevToolsException("Given value " + s + " is not found within SetEmulatedVisionDeficiencyType "));
        }

        public String toString() {
            return this.value;
        }

        public String toJson() {
            return this.value;
        }

        private static SetEmulatedVisionDeficiencyType fromJson(JsonInput input) {
            return SetEmulatedVisionDeficiencyType.fromString(input.nextString());
        }
    }

    public static enum SetEmitTouchEventsForMouseConfiguration {
        MOBILE("mobile"),
        DESKTOP("desktop");

        private String value;

        private SetEmitTouchEventsForMouseConfiguration(String value) {
            this.value = value;
        }

        public static SetEmitTouchEventsForMouseConfiguration fromString(String s) {
            return Arrays.stream(SetEmitTouchEventsForMouseConfiguration.values()).filter(rs -> rs.value.equalsIgnoreCase(s)).findFirst().orElseThrow(() -> new DevToolsException("Given value " + s + " is not found within SetEmitTouchEventsForMouseConfiguration "));
        }

        public String toString() {
            return this.value;
        }

        public String toJson() {
            return this.value;
        }

        private static SetEmitTouchEventsForMouseConfiguration fromJson(JsonInput input) {
            return SetEmitTouchEventsForMouseConfiguration.fromString(input.nextString());
        }
    }
}

