package org.openqa.selenium.devtools.v136.network.model;

import org.openqa.selenium.Beta;
import org.openqa.selenium.json.JsonInput;

/**
 * Fired upon direct_socket.TCPSocket creation.
 */
@org.openqa.selenium.Beta()
public class DirectTCPSocketCreated {

    private final org.openqa.selenium.devtools.v136.network.model.RequestId identifier;

    private final java.lang.String remoteAddr;

    private final java.lang.Integer remotePort;

    private final org.openqa.selenium.devtools.v136.network.model.DirectTCPSocketOptions options;

    private final org.openqa.selenium.devtools.v136.network.model.MonotonicTime timestamp;

    private final java.util.Optional<org.openqa.selenium.devtools.v136.network.model.Initiator> initiator;

    public DirectTCPSocketCreated(org.openqa.selenium.devtools.v136.network.model.RequestId identifier, java.lang.String remoteAddr, java.lang.Integer remotePort, org.openqa.selenium.devtools.v136.network.model.DirectTCPSocketOptions options, org.openqa.selenium.devtools.v136.network.model.MonotonicTime timestamp, java.util.Optional<org.openqa.selenium.devtools.v136.network.model.Initiator> initiator) {
        this.identifier = java.util.Objects.requireNonNull(identifier, "identifier is required");
        this.remoteAddr = java.util.Objects.requireNonNull(remoteAddr, "remoteAddr is required");
        this.remotePort = java.util.Objects.requireNonNull(remotePort, "remotePort is required");
        this.options = java.util.Objects.requireNonNull(options, "options is required");
        this.timestamp = java.util.Objects.requireNonNull(timestamp, "timestamp is required");
        this.initiator = initiator;
    }

    public org.openqa.selenium.devtools.v136.network.model.RequestId getIdentifier() {
        return identifier;
    }

    public java.lang.String getRemoteAddr() {
        return remoteAddr;
    }

    /**
     * Unsigned int 16.
     */
    public java.lang.Integer getRemotePort() {
        return remotePort;
    }

    public org.openqa.selenium.devtools.v136.network.model.DirectTCPSocketOptions getOptions() {
        return options;
    }

    public org.openqa.selenium.devtools.v136.network.model.MonotonicTime getTimestamp() {
        return timestamp;
    }

    public java.util.Optional<org.openqa.selenium.devtools.v136.network.model.Initiator> getInitiator() {
        return initiator;
    }

    private static DirectTCPSocketCreated fromJson(JsonInput input) {
        org.openqa.selenium.devtools.v136.network.model.RequestId identifier = null;
        java.lang.String remoteAddr = null;
        java.lang.Integer remotePort = 0;
        org.openqa.selenium.devtools.v136.network.model.DirectTCPSocketOptions options = null;
        org.openqa.selenium.devtools.v136.network.model.MonotonicTime timestamp = null;
        java.util.Optional<org.openqa.selenium.devtools.v136.network.model.Initiator> initiator = java.util.Optional.empty();
        input.beginObject();
        while (input.hasNext()) {
            switch(input.nextName()) {
                case "identifier":
                    identifier = input.read(org.openqa.selenium.devtools.v136.network.model.RequestId.class);
                    break;
                case "remoteAddr":
                    remoteAddr = input.nextString();
                    break;
                case "remotePort":
                    remotePort = input.nextNumber().intValue();
                    break;
                case "options":
                    options = input.read(org.openqa.selenium.devtools.v136.network.model.DirectTCPSocketOptions.class);
                    break;
                case "timestamp":
                    timestamp = input.read(org.openqa.selenium.devtools.v136.network.model.MonotonicTime.class);
                    break;
                case "initiator":
                    initiator = java.util.Optional.ofNullable(input.read(org.openqa.selenium.devtools.v136.network.model.Initiator.class));
                    break;
                default:
                    input.skipValue();
                    break;
            }
        }
        input.endObject();
        return new DirectTCPSocketCreated(identifier, remoteAddr, remotePort, options, timestamp, initiator);
    }
}
